/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.xebialabs.deployit.plumbing.CurrentVersion;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlrelease.api.v1.SettingsApi;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.views.LicenseView;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class SettingsApiImpl
implements SettingsApi {
    private final ConfigurationRepository configurationRepository;
    private final PermissionChecker permissions;
    private final LicenseService licenseService;

    @Autowired
    public SettingsApiImpl(ConfigurationRepository configurationRepository, PermissionChecker permissions, LicenseService licenseService) {
        this.configurationRepository = configurationRepository;
        this.permissions = permissions;
        this.licenseService = licenseService;
    }

    public BaseConfiguration getSettings(String id) {
        this.permissions.checkAny(PlatformPermissions.ADMIN, XLReleasePermissions.AUDIT_ALL);
        return this.configurationRepository.read(id);
    }

    public Map<String, String> getInstanceInformation() {
        HashMap<String, String> properties = new HashMap<String, String>();
        LicenseView licenseView = new LicenseView(this.licenseService.getLicense());
        properties.put("product", licenseView.getProduct());
        properties.put("edition", licenseView.getEdition());
        properties.put("version", CurrentVersion.get());
        return properties;
    }
}

