package com.xebialabs.xlrelease.actors.cluster

import com.xebialabs.xlrelease.support.pekko.spring.SpringExtension
import org.apache.pekko.discovery.ServiceDiscovery.ResolvedTarget
import org.apache.pekko.discovery.{Lookup, ServiceDiscovery}

import scala.concurrent.Future
import scala.concurrent.duration.FiniteDuration

/**
 * Pekko cluster service discovery implementation that uses database to discover existing cluster members.
 * A new node that wants to join/form a cluster registers itself using [[JdbcClusterMembersService]],
 * which then allows other nodes in the cluster to discover it.
 */
class JdbcServiceDiscovery extends ServiceDiscovery {

  lazy val jdbcClusterMembersService = SpringExtension.springBean[JdbcClusterMembersService]

  override def lookup(lookup: Lookup, resolveTimeout: FiniteDuration): Future[ServiceDiscovery.Resolved] = {
    Future.successful({
      val targets = jdbcClusterMembersService.listActiveMembers()
        .map(member => ResolvedTarget(member.host, Some(member.managementPort), None))
      ServiceDiscovery.Resolved(lookup.serviceName, targets)
    })
  }
}
