package com.xebialabs.xlrelease.db.sql

import com.xebialabs.xlrelease.db.sql.SqlBuilder._

trait LimitOffset {

  def dialect: Dialect

  def addLimitAndOffset(query: String, limitNumber: Long, offsetNumber: Long): String = {
    addLimitAndOffset(query, Option(limitNumber), Option(offsetNumber))
  }

  def addLimitAndOffset(query: String, limitNumber: Option[Long] = None, offsetNumber: Option[Long] = None): String = {
    var result = query
    val NL = System.lineSeparator
    dialect match {
      case MSSQLDialect(_) =>
        // workaround: SQL Server 2012+ requires order by for pagination, this orders by the first column in SELECT
        if (!result.toLowerCase.contains("order by")) {
          result = s"$result${NL}ORDER BY 1"
        }
        offsetNumber.orElse(Some(0)).foreach(offset => result = s"$result${NL}OFFSET $offset ROWS")
        limitNumber.foreach(limit => result = s"$result FETCH NEXT $limit ROWS ONLY")
      case DerbyDialect(_) | OracleDialect(_) =>
        offsetNumber.foreach(offset => result = s"$result${NL}OFFSET $offset ROWS")
        limitNumber.foreach(limit => result = s"$result FETCH NEXT $limit ROWS ONLY")
      case CommonDialect(_) | Db2Dialect(_) =>
        limitNumber.foreach(limit => result = s"$result${NL}LIMIT $limit")
        offsetNumber.foreach(offset => result = s"$result OFFSET $offset")
    }
    result
  }
}
