/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.events.handlers;

import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.events.ConfigurationCopiedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationUpdatedEvent;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.scheduler.RunnerRegistry;
import com.xebialabs.xlrelease.scheduler.events.JobRunnerCreatedOrUpdatedEvent;
import com.xebialabs.xlrelease.scheduler.events.JobRunnerDeletedEvent;
import com.xebialabs.xlrelease.scheduler.events.JobRunnerEvent;
import com.xebialabs.xlrelease.service.BroadcastService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005Q4A\u0001C\u0005\u0001-!AQ\u0005\u0001B\u0001B\u0003%a\u0005\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u00159\u0004\u0001\"\u00019\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u0015\u0019\u0006\u0001\"\u0003U\u0011\u0015i\u0006\u0001\"\u0003_\u0005UQuN\u0019*v]:,'/\u0012<f]RD\u0015M\u001c3mKJT!AC\u0006\u0002\u0011!\fg\u000e\u001a7feNT!\u0001D\u0007\u0002\r\u00154XM\u001c;t\u0015\tqq\"A\u0005tG\",G-\u001e7fe*\u0011\u0001#E\u0001\nq2\u0014X\r\\3bg\u0016T!AE\n\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u000b\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u00019R\u0004\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003=\rj\u0011a\b\u0006\u0003A\u0005\nQa\u001d7gi)T\u0011AI\u0001\tOJL'P\u001f7fI&\u0011Ae\b\u0002\b\u0019><w-\u001b8h\u0003A\u0011'o\\1eG\u0006\u001cHoU3sm&\u001cW\r\u0005\u0002(U5\t\u0001F\u0003\u0002*\u001f\u000591/\u001a:wS\u000e,\u0017BA\u0016)\u0005A\u0011%o\\1eG\u0006\u001cHoU3sm&\u001cW-\u0001\bsk:tWM\u001d*fO&\u001cHO]=\u0011\u00059zS\"A\u0007\n\u0005Aj!A\u0004*v]:,'OU3hSN$(/_\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007M*d\u0007\u0005\u00025\u00015\t\u0011\u0002C\u0003&\u0007\u0001\u0007a\u0005C\u0003-\u0007\u0001\u0007Q&\u0001\np]*{'MU;o]\u0016\u00148I]3bi\u0016$GCA\u001d=!\tA\"(\u0003\u0002<3\t!QK\\5u\u0011\u0015iD\u00011\u0001?\u0003\u0015)g/\u001a8u!\ty4)D\u0001A\u0015\ta\u0011I\u0003\u0002C\u001f\u00051Am\\7bS:L!\u0001\u0012!\u0003%\r{gNZ5hkJ\fG/[8o\u000bZ,g\u000e\u001e\u0015\u0003\t\u0019\u0003\"aR%\u000e\u0003!S!\u0001D\b\n\u0005)C%!C*vEN\u001c'/\u001b2f\u0003AygNS8c%Vtg.\u001a:Fm\u0016tG\u000f\u0006\u0002:\u001b\")Q(\u0002a\u0001\u001dB\u0011q\nU\u0007\u0002\u0017%\u0011\u0011k\u0003\u0002\u000f\u0015>\u0014'+\u001e8oKJ,e/\u001a8uQ\t)a)\u0001\bsK\u001eL7\u000f^3s%Vtg.\u001a:\u0015\u0005e*\u0006\"\u0002,\u0007\u0001\u00049\u0016!\u00036pEJ+hN\\3s!\tA6,D\u0001Z\u0015\tQ\u0016)\u0001\u0004sk:tWM]\u0005\u00039f\u0013\u0011BS8c%Vtg.\u001a:\u0002!Ut'/Z4jgR,'OU;o]\u0016\u0014HcA\u001d`A\")ak\u0002a\u0001/\")\u0011m\u0002a\u0001E\u0006aA-\u001a7fi\u0016\u0014VO\u001c8feB\u0011\u0001dY\u0005\u0003If\u0011qAQ8pY\u0016\fg\u000e\u000b\u0002\u0001MB\u0011qM\\\u0007\u0002Q*\u0011\u0011N[\u0001\u000bgR,'/Z8usB,'BA6m\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A7\u0002\u0007=\u0014x-\u0003\u0002pQ\n91+\u001a:wS\u000e,\u0007F\u0001\u0001r!\t9%/\u0003\u0002t\u0011\niQI^3oi2K7\u000f^3oKJ\u0004")
public class JobRunnerEventHandler
implements Logging {
    private final BroadcastService broadcastService;
    private final RunnerRegistry runnerRegistry;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        JobRunnerEventHandler jobRunnerEventHandler = this;
        synchronized (jobRunnerEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Subscribe
    public void onJobRunnerCreated(ConfigurationEvent event2) {
        ConfigurationCopiedEvent configurationCopiedEvent;
        BaseConfiguration original;
        ConfigurationDeletedEvent configurationDeletedEvent;
        BaseConfiguration conf;
        ConfigurationUpdatedEvent configurationUpdatedEvent;
        BaseConfiguration updated;
        Some some;
        ConfigurationCreatedEvent configurationCreatedEvent;
        BaseConfiguration conf2;
        ConfigurationEvent configurationEvent = event2;
        if (configurationEvent instanceof ConfigurationCreatedEvent && (conf2 = (configurationCreatedEvent = (ConfigurationCreatedEvent)configurationEvent).conf()) instanceof JobRunner) {
            JobRunner jobRunner = (JobRunner)conf2;
            some = new Some((Object)new JobRunnerCreatedOrUpdatedEvent(jobRunner));
        } else if (configurationEvent instanceof ConfigurationUpdatedEvent && (updated = (configurationUpdatedEvent = (ConfigurationUpdatedEvent)configurationEvent).updated()) instanceof JobRunner) {
            JobRunner jobRunner = (JobRunner)updated;
            some = new Some((Object)new JobRunnerCreatedOrUpdatedEvent(jobRunner));
        } else if (configurationEvent instanceof ConfigurationDeletedEvent && (conf = (configurationDeletedEvent = (ConfigurationDeletedEvent)configurationEvent).conf()) instanceof JobRunner) {
            JobRunner jobRunner = (JobRunner)conf;
            some = new Some((Object)new JobRunnerDeletedEvent(jobRunner));
        } else if (configurationEvent instanceof ConfigurationCopiedEvent && (original = (configurationCopiedEvent = (ConfigurationCopiedEvent)configurationEvent).original()) instanceof JobRunner) {
            JobRunner jobRunner = (JobRunner)original;
            some = new Some((Object)new JobRunnerCreatedOrUpdatedEvent(jobRunner));
        } else {
            some = None$.MODULE$;
        }
        Some runnerEvent = some;
        runnerEvent.foreach((Function1 & Serializable)event -> {
            this.broadcastService.broadcast(event, true);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void onJobRunnerEvent(JobRunnerEvent event) {
        JobRunnerEvent jobRunnerEvent = event;
        if (jobRunnerEvent instanceof JobRunnerCreatedOrUpdatedEvent) {
            JobRunnerCreatedOrUpdatedEvent jobRunnerCreatedOrUpdatedEvent = (JobRunnerCreatedOrUpdatedEvent)jobRunnerEvent;
            JobRunner jobRunner = jobRunnerCreatedOrUpdatedEvent.jobRunner();
            if (jobRunner.isEnabled() && Predef$.MODULE$.Integer2int(jobRunner.capacity()) > 0 && jobRunner.isAvailable()) {
                this.registerRunner(jobRunner);
                return;
            }
            this.unregisterRunner(jobRunner, false);
            return;
        }
        if (jobRunnerEvent instanceof JobRunnerDeletedEvent) {
            JobRunnerDeletedEvent jobRunnerDeletedEvent = (JobRunnerDeletedEvent)jobRunnerEvent;
            JobRunner jobRunner = jobRunnerDeletedEvent.jobRunner();
            this.unregisterRunner(jobRunner, true);
            return;
        }
        throw new MatchError((Object)jobRunnerEvent);
    }

    private void registerRunner(JobRunner jobRunner) {
        Success success;
        boolean bl;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.runnerRegistry.registerJobRunner(jobRunner));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            this.logger().error((Function0 & Serializable)() -> "Unable to register job runner [" + jobRunner.getId() + "]", (Function0 & Serializable)() -> ex);
            jobRunner.stop();
            return;
        }
        if (try_ instanceof Success && (bl = BoxesRunTime.unboxToBoolean((Object)(success = (Success)try_).value()))) {
            this.logger().debug((Function0 & Serializable)() -> "Successfully registered job runner [" + jobRunner.getId() + "]. Going to start it.");
            jobRunner.configure();
            jobRunner.start();
            return;
        }
        this.logger().debug((Function0 & Serializable)() -> "Job runner already in queue [" + jobRunner.getId() + "]. Skipping start.");
    }

    private void unregisterRunner(JobRunner jobRunner, boolean deleteRunner) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.runnerRegistry.unregisterJobRunner(jobRunner));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            this.logger().error((Function0 & Serializable)() -> "Unable to unregister job runner [" + jobRunner.getId() + "]", (Function0 & Serializable)() -> ex);
        } else if (try_ instanceof Success) {
            this.logger().trace((Function0 & Serializable)() -> "Unregistered job runner [" + jobRunner.getId() + "]");
        } else {
            throw new MatchError((Object)try_);
        }
        if (deleteRunner) {
            jobRunner.delete();
            return;
        }
        jobRunner.stop();
    }

    public JobRunnerEventHandler(BroadcastService broadcastService, RunnerRegistry runnerRegistry) {
        this.broadcastService = broadcastService;
        this.runnerRegistry = runnerRegistry;
        Logging.$init$((Logging)this);
    }
}

