/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.service;

import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.cluster.XlrCluster$;
import com.xebialabs.xlrelease.actors.cluster.XlrCluster$ClusterMemberOps$;
import com.xebialabs.xlrelease.config.XlrConfig$;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobRecoveryLogic;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.NodeId;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.filters.JobFilters;
import com.xebialabs.xlrelease.scheduler.service.JobService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.Set;
import scala.collection.SortedSetOps;
import scala.collection.immutable.List;
import scala.collection.immutable.SortedSet;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005%a\u0001\u0002\n\u0014\u0001yA\u0001\"\u000b\u0001\u0003\u0006\u0004%\tA\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005W!Aq\u0006\u0001BC\u0002\u0013\u0005\u0001\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u00032\u0011!1\u0004A!b\u0001\n\u00039\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011}\u0002!Q1A\u0005\u0002\u0001C\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\u0006\u000b\u0002!\tA\u0012\u0005\b7\u0002\u0001\r\u0011\"\u0003]\u0011\u001d\u0001\u0007\u00011A\u0005\n\u0005Daa\u001a\u0001!B\u0013i\u0006\"\u00027\u0001\t\u0003i\u0007\"\u00028\u0001\t\u0003i\u0007\u0002C8\u0001\u0011\u000b\u0007I\u0011\u00019\t\u000bm\u0004A\u0011A7\t\u000bq\u0004A\u0011A7\u0003#){'m\u00117fC:,\boU3sm&\u001cWM\u0003\u0002\u0015+\u000591/\u001a:wS\u000e,'B\u0001\f\u0018\u0003%\u00198\r[3ek2,'O\u0003\u0002\u00193\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u00035m\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003q\t1aY8n\u0007\u0001\u00192\u0001A\u0010&!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB\u0011aeJ\u0007\u0002+%\u0011\u0001&\u0006\u0002\u0011\u0015>\u0014'+Z2pm\u0016\u0014\u0018\u0010T8hS\u000e\f\u0001B[8c#V,W/Z\u000b\u0002WA\u0011a\u0005L\u0005\u0003[U\u0011\u0001BS8c#V,W/Z\u0001\nU>\u0014\u0017+^3vK\u0002\n!B[8c'\u0016\u0014h/[2f+\u0005\t\u0004C\u0001\u001a4\u001b\u0005\u0019\u0012B\u0001\u001b\u0014\u0005)QuNY*feZL7-Z\u0001\fU>\u00147+\u001a:wS\u000e,\u0007%A\tbGR|'oU=ti\u0016l\u0007j\u001c7eKJ,\u0012\u0001\u000f\t\u0003sqj\u0011A\u000f\u0006\u0003w]\ta!Y2u_J\u001c\u0018BA\u001f;\u0005E\t5\r^8s'f\u001cH/Z7I_2$WM]\u0001\u0013C\u000e$xN]*zgR,W\u000eS8mI\u0016\u0014\b%A\nsK2,\u0017m]3BGR|'oU3sm&\u001cW-F\u0001B!\tI$)\u0003\u0002Du\t\u0019\"+\u001a7fCN,\u0017i\u0019;peN+'O^5dK\u0006!\"/\u001a7fCN,\u0017i\u0019;peN+'O^5dK\u0002\na\u0001P5oSRtD#B$I\u0013*[\u0005C\u0001\u001a\u0001\u0011\u0015I\u0013\u00021\u0001,\u0011\u0015y\u0013\u00021\u00012\u0011\u00151\u0014\u00021\u00019\u0011\u0015y\u0014\u00021\u0001BQ\tIQ\n\u0005\u0002O36\tqJ\u0003\u0002Q#\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005I\u001b\u0016a\u00024bGR|'/\u001f\u0006\u0003)V\u000bQAY3b]NT!AV,\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001W\u0001\u0004_J<\u0017B\u0001.P\u0005%\tU\u000f^8xSJ,G-A\u0005jgN#\u0018M\u001d;fIV\tQ\f\u0005\u0002!=&\u0011q,\t\u0002\b\u0005>|G.Z1o\u00035I7o\u0015;beR,Gm\u0018\u0013fcR\u0011!-\u001a\t\u0003A\rL!\u0001Z\u0011\u0003\tUs\u0017\u000e\u001e\u0005\bM.\t\t\u00111\u0001^\u0003\rAH%M\u0001\u000bSN\u001cF/\u0019:uK\u0012\u0004\u0003F\u0001\u0007j!\t\u0001#.\u0003\u0002lC\tAao\u001c7bi&dW-A\u0003ti\u0006\u0014H\u000fF\u0001c\u0003\u0011\u0019Ho\u001c9\u0002\u0017\u0005\u001cGo\u001c:TsN$X-\\\u000b\u0002cB\u0011!/_\u0007\u0002g*\u0011A/^\u0001\u0006C\u000e$xN\u001d\u0006\u0003m^\fQ\u0001]3lW>T!\u0001_,\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tQ8OA\u0006BGR|'oU=ti\u0016l\u0017\u0001\u00063fi\u0016\u001cG/\u00112b]\u0012|g.\u001a3UCN\\7/A\feKR,7\r^*uC2,'+Z:feZ,GMS8cg\"\u0012\u0001A \t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019!V\u0001\u000bgR,'/Z8usB,\u0017\u0002BA\u0004\u0003\u0003\u0011qaU3sm&\u001cW\r")
public class JobCleanupService
implements JobRecoveryLogic {
    private ActorSystem actorSystem;
    private final JobQueue jobQueue;
    private final JobService jobService;
    private final ActorSystemHolder actorSystemHolder;
    private final ReleaseActorService releaseActorService;
    private volatile boolean isStarted;
    private String nodeId;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public void recoverAllJobs() {
        JobRecoveryLogic.recoverAllJobs$(this);
    }

    @Override
    public void recoverJobs(String nodeId) {
        JobRecoveryLogic.recoverJobs$(this, nodeId);
    }

    @Override
    public String convertAddressToNodeId(Address address) {
        return NodeId.convertAddressToNodeId$(this, address);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private String nodeId$lzycompute() {
        JobCleanupService jobCleanupService = this;
        synchronized (jobCleanupService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.nodeId = NodeId.nodeId$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.nodeId;
    }

    @Override
    public String nodeId() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.nodeId$lzycompute();
        }
        return this.nodeId;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        JobCleanupService jobCleanupService = this;
        synchronized (jobCleanupService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public JobQueue jobQueue() {
        return this.jobQueue;
    }

    @Override
    public JobService jobService() {
        return this.jobService;
    }

    @Override
    public ActorSystemHolder actorSystemHolder() {
        return this.actorSystemHolder;
    }

    @Override
    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    private boolean isStarted() {
        return this.isStarted;
    }

    private void isStarted_$eq(boolean x$1) {
        this.isStarted = x$1;
    }

    public void start() {
        this.isStarted_$eq(true);
    }

    public void stop() {
        this.isStarted_$eq(false);
    }

    private ActorSystem actorSystem$lzycompute() {
        JobCleanupService jobCleanupService = this;
        synchronized (jobCleanupService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.actorSystem = this.actorSystemHolder().getInstance();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.actorSystem;
    }

    public ActorSystem actorSystem() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.actorSystem$lzycompute();
        }
        return this.actorSystem;
    }

    public void detectAbandonedTasks() {
        if (this.isStarted()) {
            scala.collection.immutable.Set taskNodeIds = (scala.collection.immutable.Set)this.jobService().findDistinctNodeIds().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JobCleanupService.$anonfun$detectAbandonedTasks$1(x$1)));
            this.logger().debug((Function0 & Serializable)() -> "distinct nodeIds of tasks: " + taskNodeIds.mkString(", "));
            SortedSet aliveNodeIds = (SortedSet)((SortedSetOps)((Cluster)Cluster$.MODULE$.apply(this.actorSystem())).state().members().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)XlrCluster$ClusterMemberOps$.MODULE$.isAlive$extension(XlrCluster$.MODULE$.ClusterMemberOps(x$2))))).map((Function1 & Serializable)x$3 -> x$3.address(), Address$.MODULE$.addressOrdering()).map((Function1 & Serializable)address -> this.convertAddressToNodeId((Address)address), (Ordering)Ordering.String$.MODULE$);
            this.logger().debug((Function0 & Serializable)() -> "alive nodeIds: " + aliveNodeIds.mkString(", "));
            scala.collection.immutable.Set deadNodes = (scala.collection.immutable.Set)taskNodeIds.diff((Set)aliveNodeIds);
            deadNodes.foreach((Function1 & Serializable)nodeId -> {
                JobCleanupService.$anonfun$detectAbandonedTasks$7(this, nodeId);
                return BoxedUnit.UNIT;
            });
            return;
        }
        this.logger().debug((Function0 & Serializable)() -> "skipping detectAbandonedTasks because service is not completely initialized yet");
    }

    public void detectStaleReservedJobs() {
        JobFilters jobFilters = new JobFilters();
        jobFilters.status_$eq(Arrays.asList((Object[])new String[]{JobStatus.RESERVED.name()}));
        List<TaskJob<?>> taskJobs = this.jobService().findAllTaskJobs(jobFilters, Pageable.unpaged(), true);
        long staleReservedJobDetectionPeriodInSeconds = XlrConfig$.MODULE$.getInstance().timeouts().staleReservedJobDetectionPeriod().toSeconds();
        Instant earliestAllowedJobInstant = Instant.now().minus(staleReservedJobDetectionPeriodInSeconds, ChronoUnit.SECONDS);
        taskJobs.filter((Function1 & Serializable)j -> BoxesRunTime.boxToBoolean((boolean)JobCleanupService.$anonfun$detectStaleReservedJobs$1(earliestAllowedJobInstant, j))).foreach((Function1 & Serializable)lateJob -> {
            JobCleanupService.$anonfun$detectStaleReservedJobs$2(this, lateJob);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$detectAbandonedTasks$1(String x$1) {
        return x$1 == null;
    }

    public static final /* synthetic */ void $anonfun$detectAbandonedTasks$7(JobCleanupService $this, String nodeId) {
        $this.logger().warn((Function0 & Serializable)() -> "Discovered dead node " + nodeId + ", failing/recovering tasks assigned to that node");
        $this.recoverJobs(nodeId);
    }

    public static final /* synthetic */ boolean $anonfun$detectStaleReservedJobs$1(Instant earliestAllowedJobInstant$1, TaskJob j) {
        return j.reservationTime() == null || j.reservationTime().isBefore(earliestAllowedJobInstant$1);
    }

    public static final /* synthetic */ void $anonfun$detectStaleReservedJobs$4(JobCleanupService $this, TaskJob updatedJob) {
        $this.jobQueue().submitExisting(updatedJob);
    }

    public static final /* synthetic */ void $anonfun$detectStaleReservedJobs$3(JobCleanupService $this, TaskJob lateJob$1, JobRow updatedJobRow) {
        lateJob$1.version_$eq(updatedJobRow.version());
        lateJob$1.node_$eq(updatedJobRow.node());
        lateJob$1.status_$eq(updatedJobRow.status());
        Option$.MODULE$.apply((Object)lateJob$1).foreach((Function1 & Serializable)updatedJob -> {
            JobCleanupService.$anonfun$detectStaleReservedJobs$4($this, updatedJob);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$detectStaleReservedJobs$2(JobCleanupService $this, TaskJob lateJob) {
        $this.jobService().updateJobNodeAndStatus(lateJob, null, JobStatus.QUEUED).foreach((Function1 & Serializable)updatedJobRow -> {
            JobCleanupService.$anonfun$detectStaleReservedJobs$3($this, lateJob, updatedJobRow);
            return BoxedUnit.UNIT;
        });
    }

    @Autowired
    public JobCleanupService(JobQueue jobQueue, JobService jobService, ActorSystemHolder actorSystemHolder, ReleaseActorService releaseActorService) {
        this.jobQueue = jobQueue;
        this.jobService = jobService;
        this.actorSystemHolder = actorSystemHolder;
        this.releaseActorService = releaseActorService;
        Logging.$init$((Logging)this);
        NodeId.$init$(this);
        JobRecoveryLogic.$init$(this);
        this.isStarted = false;
    }
}

