/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.variables.FolderVariables;
import com.xebialabs.xlrelease.domain.variables.PasswordStringVariable;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.script.ScriptVariableProcessorFactory;
import com.xebialabs.xlrelease.script.VariablesHolderForScriptContext;
import com.xebialabs.xlrelease.script.XlrScriptVariables;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderVariableService;
import com.xebialabs.xlrelease.service.VariableService;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.utils.Collectors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScriptVariables {
    private VariableService variableService;
    private FolderVariableService folderVariableService;
    private PasswordEncrypter passwordEncrypter;
    private CiIdService ciIdService;
    private PermissionChecker permissionChecker;

    @Autowired
    public ScriptVariables(VariableService variableService, FolderVariableService folderVariableService, PasswordEncrypter passwordEncrypter, CiIdService ciIdService, PermissionChecker permissionChecker) {
        this.variableService = variableService;
        this.folderVariableService = folderVariableService;
        this.passwordEncrypter = passwordEncrypter;
        this.ciIdService = ciIdService;
        this.permissionChecker = permissionChecker;
    }

    public VariablesHolderForScriptContext createVariablesHolderForScriptContext(Release release, String folderId, Function<DefaultScriptService.VariablesUpdateHolder, DefaultScriptService.ScriptTaskResults> variablesSynchronizationCallback) {
        Map<String, Variable> initialReleaseVariables = this.initialReleaseVariables(release);
        Map<String, Variable> initialFolderVariables = this.initialFolderVariables(folderId);
        Map<String, Variable> initialGlobalVariables = this.initialGlobalVariables();
        return new VariablesHolderForScriptContext(release, folderId, initialReleaseVariables, initialFolderVariables, initialGlobalVariables, variablesSynchronizationCallback);
    }

    public VariablesHolderForScriptContext createVariablesHolderForScriptContext(Release release, String folderId) {
        return this.createVariablesHolderForScriptContext(release, folderId, this.noVariablesSynchronizationCallback());
    }

    private Function<DefaultScriptService.VariablesUpdateHolder, DefaultScriptService.ScriptTaskResults> noVariablesSynchronizationCallback() {
        return v -> new DefaultScriptService.ScriptTaskResults(Changes.VariablesChanges.EMPTY, Changes.VariablesChanges.EMPTY, Changes.VariablesChanges.EMPTY);
    }

    private Map<String, Variable> initialReleaseVariables(Release release) {
        return this.encryptAndNormalize(this.cloneReleaseVariables(release));
    }

    public Map<String, Variable> initialGlobalVariables() {
        return this.encryptAndNormalize(this.cloneGlobalVariables());
    }

    public Map<String, Variable> initialFolderVariables(String folderId) {
        return this.encryptAndNormalize(this.cloneFolderVariables(folderId));
    }

    public XlrScriptVariables asXlrScriptVariables(VariablesHolderForScriptContext variablesHolderForScriptContext) {
        Map<String, Object> folderVariables2 = this.folderVariables(variablesHolderForScriptContext);
        Map<String, Object> globalVariables = this.globalVariables(variablesHolderForScriptContext);
        Map<String, Object> releaseVariables = this.releaseVariables(variablesHolderForScriptContext);
        return new XlrScriptVariables(globalVariables, folderVariables2, releaseVariables);
    }

    private Map<String, Object> releaseVariables(VariablesHolderForScriptContext variablesHolderForScriptContext) {
        Map<String, Object> releaseVariables = this.toVariableValues(variablesHolderForScriptContext.getPreviousReleaseVariables());
        Release release = variablesHolderForScriptContext.getRelease();
        if (this.permissionChecker.isNotAuthenticated() || !this.permissionChecker.hasPermission(XLReleasePermissions.EDIT_RELEASE, release)) {
            releaseVariables = Collections.unmodifiableMap(releaseVariables);
        }
        return releaseVariables;
    }

    private Map<String, Object> globalVariables(VariablesHolderForScriptContext variablesHolderForScriptContext) {
        Map<String, Object> globalVariables = this.toVariableValues(variablesHolderForScriptContext.getPreviousGlobalVariables());
        if (this.permissionChecker.isNotAuthenticated() || !this.permissionChecker.hasGlobalPermission(XLReleasePermissions.EDIT_GLOBAL_VARIABLES)) {
            globalVariables = Collections.unmodifiableMap(globalVariables);
        }
        return globalVariables;
    }

    private Map<String, Object> folderVariables(VariablesHolderForScriptContext variablesHolderForScriptContext) {
        Map<String, Object> folderVariables2 = this.toVariableValues(variablesHolderForScriptContext.getPreviousFolderVariables());
        String folderId = variablesHolderForScriptContext.getFolderId();
        if (this.permissionChecker.isNotAuthenticated() || !Ids.isFolderId((String)folderId) || !this.permissionChecker.hasPermission(XLReleasePermissions.EDIT_FOLDER_VARIABLES, folderId)) {
            folderVariables2 = Collections.unmodifiableMap(folderVariables2);
        }
        return folderVariables2;
    }

    public Changes.VariablesChanges detectReleaseVariablesChanges(Task task, DefaultScriptService.VariablesUpdateHolder variableHolder) {
        Map<String, Object> releaseVariables = variableHolder.getReleaseVariables();
        Map<String, Variable> previousReleaseVariables = variableHolder.getInitialReleaseVariables();
        return ScriptVariableProcessorFactory.releaseVariableProcessor(this.ciIdService, task.getRelease()).processVariablesAndUpdateInContainer(releaseVariables, previousReleaseVariables);
    }

    public Changes.VariablesChanges detectGlobalVariablesChanges(Task task, DefaultScriptService.VariablesUpdateHolder variableHolder) {
        Map<String, Object> globalVariables = variableHolder.getGlobalVariables();
        Map<String, Variable> previousGlobalVariables = variableHolder.getInitialGlobalVariables();
        return ScriptVariableProcessorFactory.globalVariablesProcessor(this.ciIdService, task, this.variableService.findGlobalVariablesOrEmpty()).processVariablesAndUpdateInContainer(globalVariables, previousGlobalVariables);
    }

    public Changes.VariablesChanges detectFolderVariablesChanges(Task task, DefaultScriptService.VariablesUpdateHolder variableHolder) {
        Map<String, Object> scriptFolderVariables = variableHolder.getFolderVariables();
        Map<String, Variable> previousFolderVariables = variableHolder.getInitialFolderVariables();
        FolderVariables folderVariables2 = this.folderVariableService.getAllFromAncestry(task.getRelease().findFolderId());
        return ScriptVariableProcessorFactory.folderVariablesProcessor(this.permissionChecker, task, folderVariables2).processVariablesAndUpdateInContainer(scriptFolderVariables, previousFolderVariables);
    }

    public void processReleaseVariablesChanges(Release release, Changes.VariablesChanges releaseVariablesChanges) {
        ArrayList<Variable> updatedList = new ArrayList<Variable>(release.getVariables());
        boolean variablesUpdated = !releaseVariablesChanges.getUpdatedVariables().isEmpty();
        boolean variablesRemoved = updatedList.removeAll(releaseVariablesChanges.getDeletedVariables());
        releaseVariablesChanges.getUpdatedVariables().forEach(updated -> {
            int index = updatedList.indexOf(updated);
            if (index >= 0) {
                updatedList.set(index, (Variable)updated);
            }
        });
        boolean variablesAdded = updatedList.addAll(releaseVariablesChanges.getCreatedVariables());
        if (variablesUpdated || variablesAdded || variablesRemoved) {
            this.variableService.updateReleaseVariables(release, updatedList);
        }
    }

    public void processGlobalVariablesChanges(Changes.VariablesChanges globalVariablesChanges) {
        globalVariablesChanges.getDeletedVariables().forEach(v -> this.variableService.deleteGlobalVariable(v.getId()));
        globalVariablesChanges.getCreatedVariables().forEach(this.variableService::addGlobalVariable);
        globalVariablesChanges.getUpdatedVariables().forEach(this.variableService::updateGlobalVariable);
    }

    public void processFolderVariablesChanges(Changes.VariablesChanges folderVariablesChanges) {
        folderVariablesChanges.getDeletedVariables().forEach(variable -> this.folderVariableService.deleteFolderVariable(variable.getId()));
        folderVariablesChanges.getCreatedVariables().forEach(variable -> this.folderVariableService.createFolderVariable((Variable)variable));
        folderVariablesChanges.getUpdatedVariables().forEach(variable -> this.folderVariableService.updateFolderVariable((Variable)variable));
    }

    private boolean isExternalValueVariable(Variable variable) {
        return variable != null && variable.isPassword() && ((PasswordStringVariable)variable).getExternalVariableValue() != null;
    }

    private void removeExternalValueVariables(Map<String, Variable> variables) {
        if (variables == null || variables.isEmpty()) {
            return;
        }
        variables.entrySet().removeIf(entry -> this.isExternalValueVariable((Variable)entry.getValue()));
    }

    private Map<String, Variable> cloneGlobalVariables() {
        Map previousGlobalVariables = this.variableService.findGlobalVariablesOrEmpty().getVariablesByKeys();
        this.removeExternalValueVariables(previousGlobalVariables);
        this.cloneVariableValue(previousGlobalVariables);
        return previousGlobalVariables;
    }

    private Map<String, Variable> cloneFolderVariables(String folderId) {
        FolderVariables folderVariables2 = this.folderVariableService.getAllFromAncestry(folderId);
        Map previousFolderVariables = folderVariables2.getVariablesByKeys();
        this.removeExternalValueVariables(previousFolderVariables);
        this.cloneVariableValue(previousFolderVariables);
        return previousFolderVariables;
    }

    private Map<String, Variable> cloneReleaseVariables(Release release) {
        Map previousReleaseVariables = release.getVariablesByKeys();
        this.removeExternalValueVariables(previousReleaseVariables);
        this.cloneVariableValue(previousReleaseVariables);
        return previousReleaseVariables;
    }

    private void cloneVariableValue(Map<String, Variable> variablesMap) {
        variablesMap.entrySet().forEach(entry -> {
            CiHelper.eraseTokens((ConfigurationItem)((ConfigurationItem)entry.getValue()));
            entry.setValue(CiCloneHelper.cloneCi((Variable)entry.getValue()));
        });
    }

    private Map<String, Variable> encryptAndNormalize(Map<String, Variable> variables) {
        return (Map)variables.entrySet().stream().map(this::encryptPasswords).map(this::normalizeEmptyValues).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, Object> toVariableValues(Map<String, Variable> variables) {
        return (Map)this.encryptAndNormalize(variables).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Variable)entry.getValue()).getValue()));
    }

    private Map.Entry<String, Variable> encryptPasswords(Map.Entry<String, Variable> entry) {
        entry.setValue(this.encryptPassword(entry.getValue()));
        return entry;
    }

    private Map.Entry<String, Variable> normalizeEmptyValues(Map.Entry<String, Variable> entry) {
        Variable v = entry.getValue();
        v.setUntypedValue(Optional.ofNullable(v.getValue()).orElse(v.getEmptyValue()));
        return entry;
    }

    private Variable encryptPassword(Variable variable) {
        if (variable.isPassword() && !variable.isValueEmpty() && !this.passwordEncrypter.isEncrypted(variable.getValueAsString())) {
            variable.setUntypedValue((Object)this.passwordEncrypter.encrypt(variable.getValueAsString()));
        }
        return variable;
    }
}

