package com.xebialabs.xlrelease.api.v1.impl

import com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN
import com.xebialabs.xlrelease.api.v1.ManagementApi
import com.xebialabs.xlrelease.api.v1.forms.DatacenterTargetStateRequest
import com.xebialabs.xlrelease.api.v1.views.{ApplicationStatusView, ServiceStatusView}
import com.xebialabs.xlrelease.domain.{Datacenter, DatacenterTargetState}
import com.xebialabs.xlrelease.domain.management.ServiceState
import com.xebialabs.xlrelease.security.PermissionChecker
import com.xebialabs.xlrelease.service.{DatacenterService, XlrServiceManager}
import org.springframework.stereotype.Controller

import java.util
import scala.jdk.CollectionConverters._

@Controller
class ManagementApiImpl(xlrServiceManager: XlrServiceManager,
                        datacenterService: DatacenterService,
                        permissions: PermissionChecker)
  extends ManagementApi {

  override def start(): Unit = {
    permissions.check(ADMIN)
    xlrServiceManager.startAsync()
  }

  override def stop(): Unit = {
    permissions.check(ADMIN)
    xlrServiceManager.stopAsync()
  }

  override def applicationStatus: ApplicationStatusView = {
    permissions.check(ADMIN)
    val serviceStatuses = xlrServiceManager.getServicesStatus
    val isRunning = serviceStatuses.forall(_.state == ServiceState.Running)
    val serviceStatusViews = serviceStatuses.map(ServiceStatusView.from)
    new ApplicationStatusView(isRunning, serviceStatusViews.asJava)
  }

  override def getDatacenters: util.List[Datacenter] = {
    permissions.check(ADMIN)
    datacenterService.getDatacenters().asJava
  }

  override def setDatacenterState(datacenter: String, datacenterTargetStateRequest: DatacenterTargetStateRequest): Unit = {
    permissions.check(ADMIN)
    datacenterService.validateDatacenterStateChange()
    datacenterService.setDatacenterState(datacenter, DatacenterTargetState.fromString(datacenterTargetStateRequest.getTargetState))
  }

  override def deleteDatacenter(datacenter: String): Unit = {
    permissions.check(ADMIN)
    datacenterService.deleteDatacenter(datacenter)
  }
}
