package com.xebialabs.xlrelease.db.sql.archiving

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.db.ArchivedReleases._
import com.xebialabs.xlrelease.db.sql.Sql
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.domain.status.ReleaseStatus

import java.lang.Integer.valueOf

class SelectArchivedTasksBuilder(columns: String*)(implicit dialect: Dialect)
  extends BaseSelectArchivedBuilder[SelectArchivedTasksBuilder](REPORT_TASKS_TABLE_NAME, REPORT_TASKS_TABLE_ALIAS, columns: _*) {

  def withAutomated(automated: Boolean): SelectArchivedTasksBuilder = {
    conditions += Sql(s"$alias.$REPORT_TASKS_IS_AUTOMATED_COLUMN = ?", Seq(if (automated) valueOf(1) else valueOf(0)))
    this
  }

  def withReleaseStatus(status: ReleaseStatus): SelectArchivedTasksBuilder = {
    conditions += Sql(s"$alias.$REPORT_TASKS_RELEASE_STATUS_COLUMN = ?", Seq(status.value()))
    this
  }

  def excludingTypes(types: Set[Type]): SelectArchivedTasksBuilder = {
    val params = types.map((t: Type) => t.toString)
    if (params.isEmpty) {
      this
    } else {
      val placeholders = params.toSeq.map(_ => "?").mkString(", ")
      conditions += Sql(s"$alias.$REPORT_TASKS_TASK_TYPE_COLUMN NOT IN ($placeholders)", params.toSeq)
      this
    }
  }

  override def newInstance: SelectArchivedTasksBuilder = new SelectArchivedTasksBuilder(columns: _*)
}
