package com.xebialabs.xlrelease.views;

import java.util.Map;
import org.springframework.beans.BeanUtils;
import com.google.common.base.Objects;

import static com.google.common.collect.Maps.newHashMap;

public class TaskFullViewWithUsedVariables extends TaskFullView {

    private Map<String, String> usedVariables = newHashMap();

    public TaskFullViewWithUsedVariables(TaskFullView parent, Map<String, String> usedVariables) {
        BeanUtils.copyProperties(parent, this);
        this.usedVariables = usedVariables;
    }

    public Map<String, String> getUsedVariables() {
        return usedVariables;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        final TaskFullViewWithUsedVariables that = (TaskFullViewWithUsedVariables) o;
        return Objects.equal(usedVariables, that.usedVariables);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), usedVariables);
    }
}
