package com.xebialabs.deployit.plumbing

import com.xebialabs.deployit.booter.local.{ExtendByPropertyDescriptor, LocalPropertyDescriptorWithDifferentOwner}
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor

import java.lang.annotation.Annotation
import scala.annotation.tailrec
import scala.jdk.CollectionConverters._

object PropertyDescriptorJsonWriterHelper {

  @tailrec
  final def getSuperPropertyDescriptors(pd: PropertyDescriptor, acc: List[PropertyDescriptor]): List[PropertyDescriptor] = {
    (pd match {
      case extendByPD: ExtendByPropertyDescriptor => Some(extendByPD.getSuperPropertyDescriptor)
      case localPD: LocalPropertyDescriptorWithDifferentOwner => Some(localPD.getSuperPropertyDescriptor)
      case _ => None
    }) match {
      case None => acc
      case Some(sPD) => getSuperPropertyDescriptors(sPD, sPD :: acc)
    }
  }


  def getAllDescriptorAnnotations(pd: PropertyDescriptor): java.util.List[Annotation] = {
    (pd :: getSuperPropertyDescriptors(pd, List.empty[PropertyDescriptor])).flatMap(_.getAnnotations.asScala).asJava
  }
}
