package com.xebialabs.xlrelease.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlrelease.api.v1.*;

import static java.util.function.Function.identity;
import static java.util.stream.Collectors.toMap;

public class XLReleaseServiceHolder {

    private static Map<String, ? extends ApiService> apiServiceMap = Collections.emptyMap();

    private XLReleaseServiceHolder() {
    }

    public static void init(List<? extends ApiService> apiServiceList) {
        XLReleaseServiceHolder.apiServiceMap = apiServiceList.stream()
                .collect(toMap(ApiService::serviceName, identity()));
    }

    public static List<? extends ApiService> getApiServices() {
        return new ArrayList<ApiService>(apiServiceMap.values());
    }

    public static Object getRepositoryService() {
        throw new IllegalStateException("RepositoryService was removed together with Jackrabbit backend in Digital.ai Release 7.5.0, " +
                "please use public API of Digital.ai Release");
    }

    /**
     * Keeping existing API for backwards compatibility with external users
     */
    @PublicApiMember
    public static TaskApi getTaskApi() {
        return (TaskApi) apiServiceMap.get(TaskApi.SERVICE_NAME);
    }

    @PublicApiMember
    public static PhaseApi getPhaseApi() {
        return (PhaseApi) apiServiceMap.get(PhaseApi.SERVICE_NAME);
    }

    @PublicApiMember
    public static ReleaseApi getReleaseApi() {
        return (ReleaseApi) apiServiceMap.get(ReleaseApi.SERVICE_NAME);
    }

    @PublicApiMember
    public static TemplateApi getTemplateApi() {
        return (TemplateApi) apiServiceMap.get((TemplateApi.SERVICE_NAME));
    }

    @PublicApiMember
    public static ConfigurationApi getConfigurationApi() {
        return (ConfigurationApi) apiServiceMap.get(ConfigurationApi.SERVICE_NAME);
    }
}
