package com.xebialabs.xlrelease.features

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.features.distributed.{BaseDistributedFeature, DistributedFeature}
import com.xebialabs.xlrelease.features.settings.{JobSchedulerFeatureSettings, JobSchedulerStrategySettings}
import com.xebialabs.xlrelease.scheduler.strategies.BackpressuredWaitJobSchedulerStrategySettings


trait JobSchedulerFeature  extends DistributedFeature {
  def strategy: JobSchedulerStrategySettings

}

object JobSchedulerFeature extends BaseDistributedFeature[JobSchedulerFeatureSettings] with JobSchedulerFeature {
  val defaultStrategy: JobSchedulerStrategySettings = Type.valueOf(classOf[BackpressuredWaitJobSchedulerStrategySettings]).getDescriptor.newInstance("")

  override def strategy: JobSchedulerStrategySettings = {
    val strategy = Option(featureSettings.strategy).getOrElse(defaultStrategy)
    strategy
  }
}
