package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty

@Metadata(label = "Task execution log settings",
  description = "Enables ability for execution logs to be truncated after reaching a certain size."
)
class TaskExecutionLogSettings extends FeatureSettings {
  @BeanProperty
  @XLProperty(label = "Enable execution log truncating",
    description = "Enable truncating of execution logs after reaching a certain size.",
    category = "input",
    defaultValue = "false")
  var logTruncationEnabled: Boolean = _

  @BeanProperty
  @XLProperty(label = "Max execution logs size (MB)",
    description = "Actual logs size can exceed this limit if there is huge amount of logs being produced, Release will do best effort of truncating logs once it detects the limit is reached.",
    category = "input",
    defaultValue = "20")
  var maxSize: Int = _

  @BeanProperty
  @XLProperty(defaultValue = "experimental", hidden = true)
  var displayPage: String = _

  @BeanProperty
  @XLProperty(defaultValue = "how-to/configure-experimental-settings", hidden = true)
  var documentationPage: String = _

  @XLProperty(defaultValue = "60", hidden = true)
  var weight: Integer = _
}
