package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.repository.PersistenceInterceptor

trait InterceptedRepository[T <: ConfigurationItem] {
  var persistenceInterceptors: Seq[PersistenceInterceptor[T]] = Seq.empty

  def registerPersistenceInterceptor(persistenceInterceptor: PersistenceInterceptor[T]): Unit = {
    persistenceInterceptors = persistenceInterceptor +: persistenceInterceptors
  }

  protected def interceptCreate(ci: T): Unit = {
    persistenceInterceptors.foreach(_.onCreate(ci))
  }

  protected def interceptDelete(ciId: String): Unit = {
    persistenceInterceptors.foreach(_.onDelete(ciId))
  }

  protected def interceptUpdate(ci: T): Unit = {
    persistenceInterceptors.foreach(_.onUpdate(ci))
  }

  protected def afterCreate(ci: T): Unit = {
    persistenceInterceptors.foreach(_.afterCreate(ci))
  }

  protected def afterUpdate(ci: T): Unit = {
    persistenceInterceptors.foreach(_.afterUpdate(ci))
  }

  protected def afterDelete(ciId: String): Unit = {
    persistenceInterceptors.foreach(_.afterDelete(ciId))
  }
}
