package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.service.CiIdService

import java.util.UUID
import scala.reflect.ClassTag

package object persistence {
  val INDEXED_VARCHAR_LENGTH = 255
  val LONG_VARCHAR_LENGTH = 1024

  type CiUid = Integer
  type TaskCiUid = java.lang.Long
  type Token = UUID
  type Hash = String

  implicit class MapExtensions[K, V](val value: Map[K, V]) {

    import scala.jdk.CollectionConverters._

    def asJavaMutable(): java.util.Map[K, V] = new java.util.HashMap[K, V](value.asJava)
  }

  implicit class SetExtensions[V](val value: Set[V]) {

    import scala.jdk.CollectionConverters._

    def asJavaMutable(): java.util.Set[V] = new java.util.HashSet[V](value.asJava)
  }

  implicit class ListExtensions[V](val value: Seq[V]) {

    import scala.jdk.CollectionConverters._

    def asJavaMutable(): java.util.List[V] = new java.util.ArrayList[V](value.asJava)
  }

  object CiUid {
    def apply(uid: Int): CiUid = Integer.valueOf(uid)
  }

  object TaskCiUid {
    def apply(uid: Long): TaskCiUid = java.lang.Long.valueOf(uid)
  }

  def createPersistedId[T: ClassTag](parentId: String = "")(implicit ciIdService: CiIdService): String = {
    Ids.getName(ciIdService.getUniqueId(Type.valueOf(implicitly[ClassTag[T]].runtimeClass), parentId))
  }

}
