package com.xebialabs.xlrelease.scheduler

import com.xebialabs.xlplatform.cluster.ClusterMode.{Full, HotStandby}
import com.xebialabs.xlrelease.actors.ActorSystemHolder
import com.xebialabs.xlrelease.config.XlrConfig
import org.apache.pekko.actor.{ActorSystem, Address}
import org.apache.pekko.cluster.Cluster

trait NodeId {
  def actorSystemHolder: ActorSystemHolder

  def nodeId = getNodeId(actorSystemHolder.unmanagedActorSystem)

  private def getNodeId(actorSystem: ActorSystem): String = XlrConfig.getInstance.clusterMode match {
    case Full | HotStandby => convertAddressToNodeId(Cluster(actorSystem).selfAddress)
    case _ => "default"
  }

  def convertAddressToNodeId(address: Address): String = s"${address.getHost().orElse("?")}:${address.getPort().map(_.toString).orElse("?")}"
}
