package com.xebialabs.xlrelease.service;

import javax.management.MXBean;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

/**
 * Used for exposing individual services stop/start via java MBean.
 * This will not work for classes that are using spring proxies as the proxy no longer contains the data about the original class interfaces.
 * For this to work on spring proxied classes - either name the parent class to end with 'MBean' or use {@link ManagedResource} annotation.
 * <p>
 * This interface is designed to be compatible with {@link XlrServiceLifecycle}, so we could chain these if needed.
 */
@MXBean
public interface FeatureService {

    @ManagedOperation(description = "Service name")
    String serviceName();

    @ManagedOperation(description = "Start service")
    void start();

    @ManagedOperation(description = "Stop service")
    void stop();

    @ManagedOperation(description = "Is service running")
    boolean isRunning();
}
