package com.xebialabs.xlrelease.views;

import com.fasterxml.jackson.annotation.JsonInclude;

import com.xebialabs.xlrelease.security.IdentityProvider;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@JsonInclude(NON_NULL)
public class AuthenticationView {

    private final String userName;

    private final IdentityProvider identityProvider;

    public AuthenticationView(final String userName, final IdentityProvider identityProvider) {
        this.userName = userName;
        this.identityProvider = identityProvider;
    }

    public String getUserName() {
        return userName;
    }

    public IdentityProvider getIdentityProvider() {
        return identityProvider;
    }
}
