package com.xebialabs.xlrelease.actors.initializer

import com.xebialabs.xlrelease.actors.initializer.ManagedActorInitializerState.State
import grizzled.slf4j.Logging
import org.springframework.core.{Ordered => SpringOrdered}

trait ManagedActorInitializer extends Logging with SpringOrdered {
  protected var status: State = ManagedActorInitializerState.Stopped

  def doStart(): Unit

  def doStop(): Unit

  def start(): Unit = {
    if (status == ManagedActorInitializerState.Stopped) {
      doStart()
      status = ManagedActorInitializerState.Running
    }
  }

  def stop(): Unit = {
    if (status == ManagedActorInitializerState.Running) {
      status = ManagedActorInitializerState.Stopping
      doStop()
      status = ManagedActorInitializerState.Stopped
    }
  }

  def serviceName(): String = getClass.getSimpleName

  def getStatus(): State = status

  def isRunning: Boolean = status == ManagedActorInitializerState.Running
}
