/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plumbing.DescriptorJsonWriter;
import com.xebialabs.deployit.plumbing.PropertyDescriptorJsonWriter;
import com.xebialabs.xlrelease.api.v1.views.ExplodedDescriptor;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json"})
public class ExplodedDescriptorJsonWriter
implements MessageBodyWriter<ExplodedDescriptor> {
    public boolean isWriteable(Class<?> type, java.lang.reflect.Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public void writeTo(ExplodedDescriptor exploded, Class<?> type, java.lang.reflect.Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.toJson(exploded).getBytes(StandardCharsets.UTF_8));
    }

    @VisibleForTesting
    String toJson(ExplodedDescriptor exploded) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        this.writeJson(exploded, writer);
        return stringWriter.toString();
    }

    public void writeJson(ExplodedDescriptor exploded, JsonWriter writer) {
        Descriptor descriptor = exploded.getDescriptor();
        writer.object();
        DescriptorJsonWriter.descriptorProperties(writer, descriptor);
        ExplodedDescriptorJsonWriter.writeExplodedPropertyDescriptors(writer, descriptor);
        DescriptorJsonWriter.writeSuperTypes(writer, descriptor);
        DescriptorJsonWriter.writeInterfaces(writer, descriptor);
        writer.endObject();
    }

    protected static void writeExplodedPropertyDescriptors(JsonWriter writer, Descriptor descriptor) {
        writer.key("properties");
        writer.array();
        ExplodedDescriptorJsonWriter.writeExplodedProperty(writer, descriptor.getType(), "id", PropertyKind.STRING, true, true);
        ExplodedDescriptorJsonWriter.writeExplodedProperty(writer, descriptor.getType(), "type", PropertyKind.STRING, true, true);
        ExplodedDescriptorJsonWriter.writeExplodedProperty(writer, descriptor.getType(), "$createdBy", PropertyKind.STRING, false, false);
        ExplodedDescriptorJsonWriter.writeExplodedProperty(writer, descriptor.getType(), "$createdAt", PropertyKind.DATE, false, false);
        ExplodedDescriptorJsonWriter.writeExplodedProperty(writer, descriptor.getType(), "$lastModifiedBy", PropertyKind.STRING, false, false);
        ExplodedDescriptorJsonWriter.writeExplodedProperty(writer, descriptor.getType(), "$lastModifiedAt", PropertyKind.DATE, false, false);
        ExplodedDescriptorJsonWriter.writeExplodedProperty(writer, descriptor.getType(), "$scmTraceabilityDataId", PropertyKind.STRING, false, false);
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            PropertyDescriptorJsonWriter.writePropertyDescriptor(writer, pd);
        }
        writer.endArray();
    }

    static void writeExplodedProperty(JsonWriter writer, Type rootType, String name, PropertyKind kind, boolean required, boolean readOnly) {
        writer.object();
        writer.key("name").value((Object)name);
        writer.key("fqn").value((Object)(rootType + "." + name));
        writer.key("kind").value((Object)kind.name());
        writer.key("required").value(required);
        writer.key("readonly").value(readOnly);
        writer.key("hidden").value(true);
        writer.key("asContainment").value(false);
        writer.key("category").value(null);
        writer.key("description").value((Object)name);
        writer.key("label").value((Object)name);
        writer.key("inspection").value(false);
        writer.key("nested").value(false);
        writer.key("order").value(0L);
        writer.key("password").value(false);
        writer.key("referencedType").value(null);
        writer.key("requiredInspection").value(false);
        writer.key("size").value((Object)Property.Size.DEFAULT);
        writer.key("transient").value(false);
        writer.key("default").value(null);
        writer.endObject();
    }
}

