/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.authentication;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.ParseException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class UsernamePasswordAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    private static final Logger logger = LoggerFactory.getLogger(UsernamePasswordAuthenticationFilter.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public UsernamePasswordAuthenticationFilter() {
        super((RequestMatcher)new AntPathRequestMatcher("/login", "POST"));
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        if (!"POST".equals(request.getMethod())) {
            throw new AuthenticationServiceException("Authentication method must be a POST got: " + request.getMethod());
        }
        String contentType = request.getContentType();
        if (request.getContentType() == null) {
            throw new AuthenticationServiceException("Authentication payload no content type set (expecting application/json)");
        }
        try {
            ContentType type = new ContentType(contentType);
            if (type.match("application/json")) {
                return this.getAuthenticationJson(request);
            }
            if (type.match("application/x-www-form-urlencoded")) {
                return this.getAuthenticationFormEncoded(request);
            }
            throw new AuthenticationServiceException("Content type must be either `application/json` or `application/x-www-form-urlencoded` got: " + contentType);
        }
        catch (ParseException e) {
            throw new AuthenticationServiceException("Problem parsing content type: " + contentType, (Throwable)e);
        }
    }

    private Authentication getAuthenticationJson(HttpServletRequest request) {
        try {
            ServletInputStream is = request.getInputStream();
            Map data = (Map)objectMapper.readValue((InputStream)is, Map.class);
            String username = data.getOrDefault("username", "");
            username = username.trim();
            String password = data.getOrDefault("password", "");
            return this.getAuthentication(request, username, password);
        }
        catch (JsonParseException e) {
            logger.error("Problem decoding username/password", (Throwable)e);
            throw new AuthenticationServiceException("Could not parse authentication payload", (Throwable)e);
        }
        catch (JsonMappingException e) {
            logger.error("Problem decoding username/password", (Throwable)e);
            throw new AuthenticationServiceException("Could not parse authentication payload", (Throwable)e);
        }
        catch (IOException e) {
            logger.debug("I/O problem decoding username/password {}", (Object)e.getMessage());
            throw new AuthenticationServiceException("I/O problem decoding username/password", (Throwable)e);
        }
    }

    private Authentication getAuthenticationFormEncoded(HttpServletRequest request) {
        try {
            String username = this.getRequestParamOrEmpty(request, "username").trim();
            String password = this.getRequestParamOrEmpty(request, "password");
            return this.getAuthentication(request, username, password);
        }
        catch (Exception e) {
            logger.error("problem reading username and/or password {}", (Object)e.getMessage());
            throw new AuthenticationServiceException("problem reading username and/or password.", (Throwable)e);
        }
    }

    private String getRequestParamOrEmpty(HttpServletRequest request, String parameter) {
        String parameterValue = request.getParameter(parameter);
        if (parameterValue != null) {
            return parameterValue;
        }
        return "";
    }

    private Authentication getAuthentication(HttpServletRequest request, String username, String password) {
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }
}

