/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.server.jetty;

import com.google.common.base.Strings;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.server.jetty.XlrRequestLog;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.jetty.JettyConnectionMetrics;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;

public class ReleaseJettyServerCustomizer {
    private static final Logger logger = LoggerFactory.getLogger(ReleaseJettyServerCustomizer.class);

    private ReleaseJettyServerCustomizer() {
    }

    public static JettyServerCustomizer create(ServerConfiguration serverConfiguration, XlrConfig xlrConfig, MeterRegistry meterRegistry) {
        return jettyServer -> {
            ServerConnector connector;
            HttpConfiguration httpConfiguration = ReleaseJettyServerCustomizer.getHttpConfiguration(xlrConfig);
            if (serverConfiguration.isSsl()) {
                SslContextFactory.Server sslContextFactory = ReleaseJettyServerCustomizer.getSslContextFactory(serverConfiguration);
                if (xlrConfig.server_http2_enabled()) {
                    ConnectionFactory http11 = ReleaseJettyServerCustomizer.createHttpConnectionFactory(httpConfiguration, xlrConfig, HttpConnectionFactoryType.HTTP11);
                    ConnectionFactory http2 = ReleaseJettyServerCustomizer.createHttpConnectionFactory(httpConfiguration, xlrConfig, HttpConnectionFactoryType.HTTP2);
                    ConnectionFactory alpn = ReleaseJettyServerCustomizer.createHttpConnectionFactory(httpConfiguration, xlrConfig, HttpConnectionFactoryType.ALPN);
                    ConnectionFactory ssl = ReleaseJettyServerCustomizer.createSslConnectionFactory(sslContextFactory, alpn.getProtocol(), xlrConfig);
                    connector = new ServerConnector(jettyServer, sslContextFactory, new ConnectionFactory[]{ssl, alpn, http2, http11});
                } else {
                    connector = new ServerConnector(jettyServer, sslContextFactory, new ConnectionFactory[]{ReleaseJettyServerCustomizer.createHttpConnectionFactory(httpConfiguration, xlrConfig, HttpConnectionFactoryType.HTTP11)});
                }
            } else {
                ArrayList<ConnectionFactory> connectionFactories = new ArrayList<ConnectionFactory>();
                connectionFactories.add(ReleaseJettyServerCustomizer.createHttpConnectionFactory(httpConfiguration, xlrConfig, HttpConnectionFactoryType.HTTP11));
                if (xlrConfig.server_http2_enabled()) {
                    connectionFactories.add(ReleaseJettyServerCustomizer.createHttpConnectionFactory(httpConfiguration, xlrConfig, HttpConnectionFactoryType.HTTP2C));
                }
                connector = new ServerConnector(jettyServer, connectionFactories.toArray(new ConnectionFactory[0]));
            }
            connector.setIdleTimeout(30000L);
            connector.setHost(serverConfiguration.getHttpBindAddress());
            connector.setPort(serverConfiguration.getHttpPort());
            if (xlrConfig.metrics().enabled()) {
                connector.addBean((Object)new JettyConnectionMetrics(meterRegistry, (Connector)connector, (Iterable)Tags.of((String[])new String[]{"name", "release-jetty-server", "type", "jetty.connections"})));
            }
            jettyServer.setConnectors(new Connector[]{connector});
            logger.info("Server listens on {}:{} ({})", new Object[]{connector.getHost(), connector.getPort(), serverConfiguration.isSsl() ? "secure" : "not secure"});
            jettyServer.setStopTimeout(0L);
            MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
            jettyServer.addEventListener((EventListener)mbContainer);
            jettyServer.addBean((Object)mbContainer);
            XlrRequestLog logWriter = new XlrRequestLog("conf/logback-access.xml");
            jettyServer.setRequestLog((RequestLog)logWriter);
        };
    }

    private static SslContextFactory.Server getSslContextFactory(ServerConfiguration serverConfiguration) {
        logger.debug("Setting up Jetty to use SSL");
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(serverConfiguration.getKeyStorePath());
        sslContextFactory.setKeyStorePassword(serverConfiguration.getKeyStorePassword());
        sslContextFactory.setKeyManagerPassword(serverConfiguration.getKeyStoreKeyPassword());
        String protocol = serverConfiguration.getSslProtocol();
        if (!Strings.nullToEmpty((String)protocol).trim().isEmpty()) {
            sslContextFactory.setProtocol(protocol);
        }
        if (serverConfiguration.isMutualSsl()) {
            logger.debug("Setting up Jetty to use mutual SSL");
            sslContextFactory.setNeedClientAuth(true);
            sslContextFactory.setTrustStorePath(serverConfiguration.getTrustStorePath());
            sslContextFactory.setTrustStorePassword(serverConfiguration.getTrustStorePassword());
        }
        return sslContextFactory;
    }

    private static HttpConfiguration getHttpConfiguration(XlrConfig xlrConfig) {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer(xlrConfig.server_ssl_sniHostCheck(), TimeUnit.SECONDS.convert(365L, TimeUnit.DAYS), true));
        httpConfiguration.setSendServerVersion(false);
        httpConfiguration.setSendXPoweredBy(false);
        return httpConfiguration;
    }

    private static ConnectionFactory createHttpConnectionFactory(HttpConfiguration httpConfiguration, XlrConfig xlrConfig, HttpConnectionFactoryType factoryType) {
        return switch (factoryType) {
            case HttpConnectionFactoryType.HTTP11 -> new HttpConnectionFactory(httpConfiguration);
            case HttpConnectionFactoryType.HTTP2 -> new HTTP2ServerConnectionFactory(httpConfiguration);
            case HttpConnectionFactoryType.HTTP2C -> new HTTP2CServerConnectionFactory(httpConfiguration);
            case HttpConnectionFactoryType.ALPN -> new ALPNServerConnectionFactory(new String[0]);
            default -> throw new IllegalStateException();
        };
    }

    private static ConnectionFactory createSslConnectionFactory(SslContextFactory.Server sslContextFactory, String protocol, XlrConfig xlrConfig) {
        SslConnectionFactory connectionFactory = new SslConnectionFactory(sslContextFactory, protocol);
        return connectionFactory;
    }

    private static enum HttpConnectionFactoryType {
        HTTP11,
        HTTP2,
        HTTP2C,
        ALPN;

    }
}

