/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlrelease.domain.distributed.events.DistributedSSEEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedSendSSEEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedSubscribeSSEEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedUnsubscribeAllSSEEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedUnsubscribeSSEEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedXLReleaseEvent;
import com.xebialabs.xlrelease.events.AsyncSubscribe;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.repository.SSERepository;
import com.xebialabs.xlrelease.service.BroadcastService;
import com.xebialabs.xlrelease.user.User;
import jakarta.ws.rs.sse.SseEventSink;
import org.springframework.stereotype.Service;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005ua\u0001B\u0007\u000f\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!)!\u0006\u0001C\u0001W!)q\u0006\u0001C\u0001a!)!\t\u0001C\u0001\u0007\")!\t\u0001C\u0001#\")Q\u000b\u0001C\u0001-\")Q\u000b\u0001C\u00011\")1\f\u0001C\u00019\")a\f\u0001C\u0001?\")Q\r\u0001C\u0001M\")1\u000e\u0001C\u0001Y\nQ1k]3TKJ4\u0018nY3\u000b\u0005=\u0001\u0012aB:feZL7-\u001a\u0006\u0003#I\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005M!\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005)\u0012aA2p[\u000e\u00011C\u0001\u0001\u0019!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fM\u0006i1o]3SKB|7/\u001b;pef\u0004\"\u0001I\u0012\u000e\u0003\u0005R!A\t\t\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002%C\ti1kU#SKB|7/\u001b;pef\f\u0001C\u0019:pC\u0012\u001c\u0017m\u001d;TKJ4\u0018nY3\u0011\u0005\u001dBS\"\u0001\b\n\u0005%r!\u0001\u0005\"s_\u0006$7-Y:u'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}Q\u0019A&\f\u0018\u0011\u0005\u001d\u0002\u0001\"\u0002\u0010\u0004\u0001\u0004y\u0002\"B\u0013\u0004\u0001\u00041\u0013aE:vEN\u001c'/\u001b2f+N,'\u000fV8TS:\\GCA\u00195!\tI\"'\u0003\u000245\t!QK\\5u\u0011\u0015)D\u00011\u00017\u0003\u0011\u0019\u0018N\\6\u0011\u0005]\u0002U\"\u0001\u001d\u000b\u0005eR\u0014aA:tK*\u00111\bP\u0001\u0003eNT!!\u0010 \u0002\u0005]\u001c(\"A \u0002\u000f)\f7.\u0019:uC&\u0011\u0011\t\u000f\u0002\r'N,WI^3oiNKgn[\u0001\u0015gV\u00147o\u0019:jE\u0016$v\u000e]5d)>,6/\u001a:\u0015\u0005E\"\u0005\"B#\u0006\u0001\u00041\u0015!\u0002;pa&\u001c\u0007CA$O\u001d\tAE\n\u0005\u0002J55\t!J\u0003\u0002L-\u00051AH]8pizJ!!\u0014\u000e\u0002\rA\u0013X\rZ3g\u0013\ty\u0005K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001bj!2!\r*T\u0011\u0015)e\u00011\u0001G\u0011\u0015!f\u00011\u0001G\u0003!)8/\u001a:oC6,\u0017AF;ogV\u00147o\u0019:jE\u0016$v\u000e]5d)>,6/\u001a:\u0015\u0005E:\u0006\"B#\b\u0001\u00041EcA\u0019Z5\")Q\t\u0003a\u0001\r\")A\u000b\u0003a\u0001\r\u0006\u0019RO\\:vEN\u001c'/\u001b2f\u00032dWk]3sgR\u0011\u0011'\u0018\u0005\u0006\u000b&\u0001\rAR\u0001\ng\u0016tG-\u0012<f]R$B!\r1bG\")QI\u0003a\u0001\r\")!M\u0003a\u0001\r\u0006IQM^3oi:\u000bW.\u001a\u0005\u0006I*\u0001\rAR\u0001\ba\u0006LHn\\1e\u00039A\u0017m]!di&4X-V:feN$\"a\u001a6\u0011\u0005eA\u0017BA5\u001b\u0005\u001d\u0011un\u001c7fC:DQ!R\u0006A\u0002\u0019\u000bqa\u001c8Fm\u0016tG\u000f\u0006\u00022[\")a\u000e\u0004a\u0001_\u0006)QM^3oiB\u0011\u0001o^\u0007\u0002c*\u0011!o]\u0001\u0007KZ,g\u000e^:\u000b\u0005Q,\u0018a\u00033jgR\u0014\u0018NY;uK\u0012T!A\u001e\t\u0002\r\u0011|W.Y5o\u0013\tA\u0018OA\nESN$(/\u001b2vi\u0016$7kU#Fm\u0016tG\u000f\u000b\u0002\ruB\u001110`\u0007\u0002y*\u0011!\u000fE\u0005\u0003}r\u0014a\"Q:z]\u000e\u001cVOY:de&\u0014W\rK\u0002\u0001\u0003\u0003\u0001B!a\u0001\u0002\u00125\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016TA!a\u0003\u0002\u000e\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002\u0010\u0005\u0019qN]4\n\t\u0005M\u0011Q\u0001\u0002\b'\u0016\u0014h/[2fQ\r\u0001\u0011q\u0003\t\u0004w\u0006e\u0011bAA\u000ey\niQI^3oi2K7\u000f^3oKJ\u0004")
public class SseService {
    private final SSERepository sseRepository;
    private final BroadcastService broadcastService;

    public void subscribeUserToSink(SseEventSink sink) {
        String username = User.AUTHENTICATED_USER.getName();
        this.sseRepository.addUserToSink(username, sink);
    }

    public void subscribeTopicToUser(String topic) {
        String username = User.AUTHENTICATED_USER.getName();
        this.subscribeTopicToUser(topic, username);
    }

    public void subscribeTopicToUser(String topic, String username) {
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedSubscribeSSEEvent(topic, username), true);
    }

    public void unsubscribeTopicToUser(String topic) {
        String username = User.AUTHENTICATED_USER.getName();
        this.unsubscribeTopicToUser(topic, username);
    }

    public void unsubscribeTopicToUser(String topic, String username) {
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedUnsubscribeSSEEvent(topic, username), true);
    }

    public void unsubscribeAllUsers(String topic) {
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedUnsubscribeAllSSEEvent(topic), true);
    }

    public void sendEvent(String topic, String eventName, String payload) {
        this.broadcastService.broadcast((DistributedXLReleaseEvent)new DistributedSendSSEEvent(topic, eventName, payload), true);
    }

    public boolean hasActiveUsers(String topic) {
        return this.sseRepository.getUsers(topic).nonEmpty();
    }

    @AsyncSubscribe
    public void onEvent(DistributedSSEEvent event) {
        DistributedSSEEvent distributedSSEEvent = event;
        if (distributedSSEEvent instanceof DistributedSubscribeSSEEvent) {
            DistributedSubscribeSSEEvent distributedSubscribeSSEEvent = (DistributedSubscribeSSEEvent)distributedSSEEvent;
            String topic = distributedSubscribeSSEEvent.topic();
            String username = distributedSubscribeSSEEvent.user();
            this.sseRepository.addTopicToUser(topic, username);
            return;
        }
        if (distributedSSEEvent instanceof DistributedUnsubscribeSSEEvent) {
            DistributedUnsubscribeSSEEvent distributedUnsubscribeSSEEvent = (DistributedUnsubscribeSSEEvent)distributedSSEEvent;
            String topic = distributedUnsubscribeSSEEvent.topic();
            String username = distributedUnsubscribeSSEEvent.user();
            this.sseRepository.removeTopicToUser(topic, username);
            return;
        }
        if (distributedSSEEvent instanceof DistributedUnsubscribeAllSSEEvent) {
            DistributedUnsubscribeAllSSEEvent distributedUnsubscribeAllSSEEvent = (DistributedUnsubscribeAllSSEEvent)distributedSSEEvent;
            String topic = distributedUnsubscribeAllSSEEvent.topic();
            this.sseRepository.removeAllUsersFromTopic(topic);
            return;
        }
        if (distributedSSEEvent instanceof DistributedSendSSEEvent) {
            DistributedSendSSEEvent distributedSendSSEEvent = (DistributedSendSSEEvent)distributedSSEEvent;
            String topic = distributedSendSSEEvent.topic();
            String eventName = distributedSendSSEEvent.eventName();
            String payload = distributedSendSSEEvent.payload();
            this.sseRepository.sendEventToSink(topic, eventName, payload);
            return;
        }
        throw new MatchError((Object)distributedSSEEvent);
    }

    public SseService(SSERepository sseRepository, BroadcastService broadcastService) {
        this.sseRepository = sseRepository;
        this.broadcastService = broadcastService;
    }
}

