package com.xebialabs.xlrelease.actors.cluster

import com.xebialabs.xlrelease.actors.ActorSystemHolder
import org.apache.pekko.cluster.Cluster
import org.apache.pekko.management.scaladsl.PekkoManagement

trait XlrClusterInformation {
  def myself: ClusterMember
}

case class XlrClusterInformationImpl(actorSystemHolder: ActorSystemHolder) extends XlrClusterInformation {
  private def cluster: Cluster = actorSystemHolder.cluster()
  private def management: PekkoManagement = actorSystemHolder.pekkoManagement()

  def myself: ClusterMember = ClusterMember(
    cluster.selfDataCenter,
    cluster.selfAddress.protocol,
    actorSystemHolder.actorSystemName(),
    management.settings.getHttpEffectiveBindHostname,
    management.settings.getHttpEffectiveBindPort,
    cluster.selfAddress.port.getOrElse(0)
  )
}
