package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import java.util
import scala.beans.BeanProperty

@Metadata(label = "Reference variables",
  description = "The Reference variable inherently supports HTTP server configurations by default. Select additional types to be used with the Reference variable.")
class ReferenceVariablesFeatureSettings extends FeatureSettings {
  @BeanProperty
  @XLProperty(label = "Connection type", description = "Choose Connection (Synthetic) type to be used with the Reference variable.", category = "input", defaultValue = "", required = false)
  var typeList: java.util.List[String] = new util.ArrayList[String]()

  @BeanProperty
  @XLProperty(defaultValue = "variable", hidden = true)
  var displayIcon: String = _

  @BeanProperty
  @XLProperty(defaultValue = "advanced-settings", hidden = true)
  var displayPage: String = _

  @BeanProperty
  @XLProperty(defaultValue = "how-to/configure-advanced-settings#configure-reference-variable-connection", hidden = true)
  var documentationPage: String = _

  @XLProperty(defaultValue = "0", hidden = true)
  var weight: Integer = _

}
