package com.xebialabs.xlrelease.repository

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem

trait ItemRepository[T <: ConfigurationItem] {
  type ITEM = T

  def exists(id: String): Boolean = read(id).nonEmpty

  def create(item: ITEM): ITEM

  def read(id: String): Option[ITEM]

  def update(item: ITEM): Boolean = read(item.getId).exists { _ =>
    if (delete(item.getId)) {
      create(item)
      true
    } else {
      false
    }
  }

  def delete(id: String): Boolean
}
