package com.xebialabs.xlrelease.scheduler.service

import com.xebialabs.xlplatform.cluster.ClusterMode
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.scheduler.JobQueue
import com.xebialabs.xlrelease.service.{NoopXlrServiceLifecycle, XlrServiceLifecycleOrder}
import grizzled.slf4j.Logging
import org.springframework.context.annotation.Profile
import org.springframework.scheduling.annotation.{EnableScheduling, SchedulingConfigurer}
import org.springframework.scheduling.config.ScheduledTaskRegistrar
import org.springframework.stereotype.Service

import scala.jdk.DurationConverters.ScalaDurationOps


@Service
@EnableScheduling
@Profile(Array(ClusterMode.HOT_STANDBY, ClusterMode.FULL))
class JobQueuePopulatorService(jobQueue: JobQueue,
                               databaseJobProvider: DatabaseJobProvider,
                               xlrConfig: XlrConfig)
  extends SchedulingConfigurer
    with NoopXlrServiceLifecycle
    with Logging {

  override def getOrder: Int = XlrServiceLifecycleOrder.JOB_QUEUE_POPULATOR_SERVICE

  private def populateJobQueue(): Unit = {
    if (isRunning && jobQueue.isRunning() && jobQueue.size() == 0) {
      logger.debug("Going to populate jobQueue with new jobs")
      databaseJobProvider.queueJobsFromDatabase()
    }
  }

  override def configureTasks(taskRegistrar: ScheduledTaskRegistrar): Unit = {
    val delay = xlrConfig.durations.jobQueuePopulateInterval
    taskRegistrar.addFixedDelayTask(() => populateJobQueue(), delay.toJava)
  }
}

