package com.xebialabs.xlrelease.spring.configuration;

import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.ldap.LdapHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;

@AutoConfiguration
@ConditionalOnBean(BaseLdapPathContextSource.class)
@ConditionalOnEnabledHealthIndicator("ldap")
public class XlrLdapHealthAutoConfiguration {

    SpringSecurityLdapTemplate template;

    public XlrLdapHealthAutoConfiguration(BaseLdapPathContextSource ldapServer) {
        this.template = new SpringSecurityLdapTemplate(ldapServer);
    }

    @Bean
    public HealthContributor ldapHealthContributor() {
        return new LdapHealthIndicator(template);
    }
}
