package com.xebialabs.xlrelease.actors.initializer

import com.xebialabs.xlrelease.actors._
import com.xebialabs.xlrelease.actors.initializer.UserLastActiveInitializer.UserLastActiveManagedActor
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.repository.{UserProfileRepository, UserTokenRepository}
import grizzled.slf4j.Logging
import org.springframework.context.annotation.{Bean, Configuration}

object UserLastActiveInitializer {
  type UserLastActiveManagedActor = ManagedActor[UserLastActiveActor]
}

@Configuration
class UserLastActiveInitializer(userProfileRepository: UserProfileRepository,
                                userTokenRepository: UserTokenRepository,
                                xlrConfig: XlrConfig,
                                systemHolder: ActorSystemHolder)
  extends Logging {

  @Bean
  def userLastActiveManagedActor(): UserLastActiveManagedActor = {
    import xlrConfig.features.userLastActiveActor._
    logger.debug("Initializing userLastActive actor...")
    val props = UserLastActiveActor.props(userProfileRepository, userTokenRepository, maxBufferSize, batchSize, flushInterval)
    systemHolder.actorOf(props, UserLastActiveActor.name)
  }

}

