package com.xebialabs.xlrelease.customscripts;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.ContainerTask;
import com.xebialabs.xlrelease.domain.ExportHook;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.utils.TaskTypes;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.events.system.TypesReloaded;

import static com.xebialabs.xlrelease.domain.CustomScriptTask.UNKNOWN_TYPE;
import static com.xebialabs.xlrelease.domain.Task.UNKNOWN_TASK_TYPE;

@Component
public class ScriptTypes {
    private Collection<Type> pythonScriptTypes;
    private Collection<Type> containerTaskTypes;
    private Collection<Type> releaseTriggerTypes;
    private Collection<Type> exportHookTypes;
    public static final Set<Type> UNKNOWN_TYPES = Set.of(UNKNOWN_TYPE, UNKNOWN_TASK_TYPE);

    public ScriptTypes(EventBus eventBus) {
        eventBus.register(this);
        reload();
    }

    @Subscribe
    public void onTypesReloaded(TypesReloaded event) {
        reload();
    }

    private void reload() {
        pythonScriptTypes = getTypes("Custom Tasks", PythonScript.class);
        containerTaskTypes = getTypes("Container Tasks", ContainerTask.class);
        releaseTriggerTypes = getTypes("Release triggers", ReleaseTrigger.class);
        exportHookTypes = getTypes("Export hooks", ExportHook.class);
    }

    public Collection<Type> getPythonScriptTypes() {
        return pythonScriptTypes;
    }

    public Collection<Type> getContainerTaskTypes() {
        return containerTaskTypes;
    }

    public Collection<Type> getReleaseTriggerTypes() {
        return releaseTriggerTypes;
    }

    public Collection<Type> getExportHookTypes() {
        return exportHookTypes;
    }

    private List<Type> getTypes(String label, Class<? extends ConfigurationItem> type) {
        List<Type> types = TaskTypes.getTypes(type).stream()
                .filter(t -> !UNKNOWN_TYPES.contains(t))
                .collect(Collectors.toList());

        StringBuffer typeList = new StringBuffer("\n");
        for (Type t : types) {
            typeList.append("  ").append(t).append("\n");
        }
        logger.info("{}: {}", label, typeList);

        return types;
    }

    private static final Logger logger = LoggerFactory.getLogger(ScriptTypes.class);
}
