package com.xebialabs.xlrelease.domain.tasks.gate;

import java.util.List;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.views.GateConditionView;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.converters.BaseTaskViewConverter;
import com.xebialabs.xlrelease.views.converters.DependencyViewConverter;

import static com.xebialabs.xlrelease.builder.TaskBuilder.newGateTask;
import static java.util.stream.Collectors.toList;

@Component
public class GateTaskViewConverter extends BaseTaskViewConverter<GateTask> {

    @Override
    public TaskFullView toFullView(final GateTask task, final List<Type> allowedTaskTypesForAuthenticatedUser) {
        TaskFullView gateView = super.toFullView(task, allowedTaskTypesForAuthenticatedUser);
        gateView.setConditions(task.getConditions().stream().map(GateConditionView::new).collect(toList()));
        gateView.setDependencies(
                task.getDependencies().stream().map(DependencyViewConverter::toDependencyView).collect(toList())
        );
        return gateView;
    }

    @Override
    protected GateTask fromView(final TaskFullView view) {
        return newGateTask().build();
    }

    @Override
    protected Class<GateTask> getTaskClass() {
        return GateTask.class;
    }
}
