package com.xebialabs.xlrelease.scheduler

import com.xebialabs.xlrelease.scheduler.RestartableExecutorService.NOT_AVAILABLE_MSG
import grizzled.slf4j.Logging

import java.util.concurrent._

trait RestartableScheduledExecutorService extends RestartableExecutorService with ScheduledExecutorService

case class RestartableScheduledExecutor(executorName: String,
                                        executorFactory: () => ScheduledExecutorService,
                                        override val shutdownTimeout: Long)
  extends RestartableExecutor[ScheduledExecutorService](executorName, executorFactory, shutdownTimeout)
    with RestartableScheduledExecutorService
    with Logging {

  override def schedule(runnable: Runnable, l: Long, timeUnit: TimeUnit): ScheduledFuture[_] = {
    original.map(_.schedule(runnable, l, timeUnit)).getOrElse(throw new RejectedExecutionException(NOT_AVAILABLE_MSG))
  }

  override def schedule[V](callable: Callable[V], l: Long, timeUnit: TimeUnit): ScheduledFuture[V] = {
    original.map(_.schedule(callable, l, timeUnit)).getOrElse(throw new RejectedExecutionException(NOT_AVAILABLE_MSG))
  }

  override def scheduleAtFixedRate(runnable: Runnable, l: Long, l1: Long, timeUnit: TimeUnit): ScheduledFuture[_] = {
    original.map(_.scheduleAtFixedRate(runnable, l, l1, timeUnit)).getOrElse(throw new RejectedExecutionException(NOT_AVAILABLE_MSG))
  }

  override def scheduleWithFixedDelay(runnable: Runnable, l: Long, l1: Long, timeUnit: TimeUnit): ScheduledFuture[_] = {
    original.map(_.scheduleWithFixedDelay(runnable, l, l1, timeUnit)).getOrElse(throw new RejectedExecutionException(NOT_AVAILABLE_MSG))
  }
}
