package com.xebialabs.xlrelease.scheduler.logs

import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionRepository.{DeleteOperation, FindOperation}
import org.springframework.data.domain.{Page, Pageable}

import java.time.Instant

trait TaskExecutionRepository {
  def read(taskId: String, executionId: String): Option[TaskExecutionEntry]

  def finishExecution(taskId: String, executionId: String, endDate: Instant): Option[TaskExecutionEntry]

  def update(update: TaskExecutionEntry): Option[TaskExecutionEntry]

  def delete(deleteOperation: DeleteOperation): Unit

  def find(findOperation: FindOperation, pageable: Pageable): Page[TaskExecutionEntry]

  def markAsTruncated(taskId: String, executionId: String): Unit
}

object TaskExecutionRepository {
  sealed trait FindOperationComparator

  case object GreaterThan extends FindOperationComparator

  case object LessThan extends FindOperationComparator

  sealed trait FindOperation

  case class ByTaskId(taskId: String) extends FindOperation

  case class FinishedTaskAndExecutions(comparator: FindOperationComparator, lastModifiedDate: Instant) extends FindOperation

  sealed trait DeleteOperation

  case class Delete(taskId: String, executionId: String) extends DeleteOperation

  case class DeleteWithTaskExecutionEntry(id: TaskExecutionEntry) extends DeleteOperation
}
