package com.xebialabs.xlrelease.security.authentication;

import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

import com.xebialabs.xlrelease.principaldata.LdapGroupEmailProvider;

/**
 * Since spring security 3.2.0, internal authentication exception stops the authentication: https://jira.spring.io/browse/SEC-2367.
 * But if LDAP authentication fails due to LDAP communication issue, we want to try internal authentication.
 */
// TODO: it would be much better to create the UserProfile here
// TODO: maybe also normalize the username to lowercase here?
// TODO: normalizing may require an upgrader for the Users/Roles/Tasks in DB.
// TODO: use a different UserDetailsMapper that also gets fullname and email so it does not need to be retrieved separately
// TODO: map roles/permissions/UserProfile loginAllowed to granted authorities and properly use spring security (and enjoy better performance, since that will cut away a lot of jcr/db calls)
// TODO: use spring security secured annotations in stead of manual checks
public class LdapAuthenticationProvider extends org.springframework.security.ldap.authentication.LdapAuthenticationProvider {

    private LdapGroupEmailProvider groupEmailProvider;

    private String externalIdAttribute;

    public LdapAuthenticationProvider(LdapAuthenticator authenticator, LdapAuthoritiesPopulator authoritiesPopulator, LdapGroupEmailProvider groupEmailProvider) {
        super(authenticator, authoritiesPopulator);
        this.groupEmailProvider = groupEmailProvider;
    }

    public LdapAuthenticationProvider(LdapAuthenticator authenticator, LdapAuthoritiesPopulator authoritiesPopulator) {
        super(authenticator, authoritiesPopulator);
    }

    public LdapAuthenticationProvider(LdapAuthenticator authenticator) {
        super(authenticator);
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            return super.authenticate(authentication);
        } catch (InternalAuthenticationServiceException e) {
            throw new AuthenticationServiceException(e.getMessage(), e.getCause());
        }
    }

    public LdapGroupEmailProvider getGroupEmailProvider() {
        return groupEmailProvider;
    }

    public String getExternalIdAttribute() {
        return externalIdAttribute;
    }

    public void setExternalIdAttribute(final String externalIdAttribute) {
        this.externalIdAttribute = externalIdAttribute;
    }
}
