package com.xebialabs.xlrelease.serialization;

import org.springframework.data.domain.Page;
import com.fasterxml.jackson.databind.module.SimpleModule;

import com.xebialabs.xlrelease.domain.variables.*;
import com.xebialabs.xlrelease.serialization.domain.*;

public class XLReleaseJacksonModule extends SimpleModule {

    public XLReleaseJacksonModule() {
        super("xl-release");
    }

    @Override
    public void setupModule(final SetupContext context) {
        super.setupModule(context);
        context.setMixInAnnotations(GlobalVariables.class, MaskedCiSerializingJsonMixin.class);
        context.setMixInAnnotations(FolderVariables.class, MaskedCiSerializingJsonMixin.class);
        context.setMixInAnnotations(Variable.class, CiSerializingJsonMixin.class);
        context.setMixInAnnotations(ValueProviderConfiguration.class, CiSerializingJsonMixin.class);
        context.setMixInAnnotations(PasswordStringVariable.class, PasswordStringVariableJsonMixin.class);
        context.setMixInAnnotations(Page.class, PageSerializingJsonMixin.class);
        try {
            context.setMixInAnnotations(Class.forName("com.xebialabs.xlrelease.reports.filters.ReportFilter"), CiSerializingJsonMixin.class);
        } catch (ClassNotFoundException e) {
            // ignore
        }
    }
}
