package com.xebialabs.xlrelease.service

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.xlrelease.domain.{BaseConfiguration, Trigger}
import com.xebialabs.xlrelease.repository.{ConfigurationRepository, TriggerRepository}
import com.xebialabs.xlrelease.service.DisableWebhook.{DisableWebhookConfig, DisableWebhookTrigger}

import scala.collection.mutable
import scala.jdk.CollectionConverters._

sealed trait DisableWebhook {
  def propName: String
}
object DisableWebhook {

  case class DisableWebhookConfig private(propName: String) extends DisableWebhook

  case object DisableWebhookTrigger extends DisableWebhook {
    val propName = "enabled"
  }

  def disableWebhookSource: DisableWebhookConfig = DisableWebhookConfig("sourceEnabled")

  def disableWebhookConsumer: DisableWebhookConfig = DisableWebhookConfig("consumerEnabled")
}

trait WebhookMissingTypeChecker {
  def configurationRepository: ConfigurationRepository

  def triggerRepository: TriggerRepository

  def findEventProcessorsWithMissingEventType(): mutable.Seq[BaseConfiguration] =
    configurationRepository
      .findAllByType[BaseConfiguration](Type.valueOf("events.BaseProcessor"))
      .asScala
      .filter(conf => conf.getProperty[Boolean]("consumerEnabled"))
      .filterNot(conf => isTypeExist(conf, "inputEventType") && isTypeExist(conf, "outputEventType"))

  def findWebhookEndpointsWithMissingEventType(): mutable.Buffer[BaseConfiguration] =
    configurationRepository
      .findAllByType[BaseConfiguration](Type.valueOf("events.WebhookEndpoint"))
      .asScala
      .filter(conf => conf.getProperty[Boolean]("sourceEnabled"))
      .filterNot(conf => isTypeExist(conf, "outputEventType"))

  def findEventBasedTriggersWithMissingEventType(): mutable.Buffer[Trigger] =
    triggerRepository.findByType(List(Type.valueOf("events.EventBasedTrigger")), null)
      .getContent.asScala.filter(_.isEnabled).filterNot(conf => isTypeExist(conf, "eventType"))

  def disable[T <: BaseConfigurationItem](disableWebhook: DisableWebhook)(config: T): Unit = {
    config.setProperty(disableWebhook.propName, false)
    disableWebhook match {
      case DisableWebhookConfig(_) =>
        configurationRepository.update(config.asInstanceOf[BaseConfiguration])
      case DisableWebhookTrigger =>
        triggerRepository.update(config.asInstanceOf[Trigger])
    }
  }

  private def isTypeExist[T <: BaseConfigurationItem](ci: T, propName: String): Boolean =
    Type.valueOf(ci.getProperty[String](propName)).exists()

}
