package com.xebialabs.xlrelease.utils

import java.time.Instant

object InstantUtils {

  def maxInstant(a: Option[Instant], b: Option[Instant]): Option[Instant] = {
    (a, b) match {
      case (None, None) => None
      case (None, Some(_)) => b
      case (Some(_), None) => a
      case (Some(instantA), Some(instantB)) => Some(if (instantA.isAfter(instantB)) instantA else instantB)
    }
  }
}
