package com.xebialabs.xlrelease.views;

import com.xebialabs.xlrelease.configuration.ArchivingSettings;

public class ArchivingSettingsView {

    private Integer releaseAgeToDeleteFromJcr;
    private Boolean preArchivingEnabled;
    private Boolean skipArchiveAllowed;

    public ArchivingSettingsView(ArchivingSettings archivingSettings) {
        this.releaseAgeToDeleteFromJcr = archivingSettings.getReleaseAgeToDeleteFromJcr();
        this.preArchivingEnabled = archivingSettings.getPreArchivingEnabled();
        this.skipArchiveAllowed = archivingSettings.getSkipArchiveAllowed();
    }

    public Integer getReleaseAgeToDeleteFromJcr() {
        return releaseAgeToDeleteFromJcr;
    }

    public Boolean getPreArchivingEnabled() {
        return preArchivingEnabled;
    }

    public Boolean getSkipArchiveAllowed() {
        return skipArchiveAllowed;
    }
}
