package com.xebialabs.xlrelease.views.converters;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.views.CommentView;
import com.xebialabs.xlrelease.views.UserView;

@Component
public class CommentViewConverter {

    @Autowired
    private UserViewConverter userViewConverter;

    public CommentView toFullView(Comment comment) {
        UserView authorView = userViewConverter.toUserView(comment.getAuthor());
        return new CommentView(comment, authorView);
    }
}
