package com.xebialabs.deployit.plumbing;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;
import com.google.common.annotations.VisibleForTesting;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.xltype.serialization.json.JsonWriter;

import static com.xebialabs.deployit.plumbing.AbstractConfigurationItemReaderWriter.getClassFromGenericType;
import static com.xebialabs.deployit.plumbing.PropertyDescriptorJsonWriter.writePropertyDescriptor;
import static java.nio.charset.StandardCharsets.UTF_8;

@Component
@Provider
@Produces({MediaType.APPLICATION_JSON})
public class PropertyDescriptorsJsonWriter implements MessageBodyWriter<Collection<PropertyDescriptor>> {
    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = getClassFromGenericType(genericType);
        }
        return PropertyDescriptor.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(Collection<PropertyDescriptor> propertyDescriptors, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(Collection<PropertyDescriptor> propertyDescriptors, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(propertyDescriptors).getBytes(UTF_8));
    }

    @VisibleForTesting
    String toJson(Collection<PropertyDescriptor> propertyDescriptors) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter);
        writer.array();

        for (PropertyDescriptor descriptor : propertyDescriptors) {
            writePropertyDescriptor(writer, descriptor);
        }

        writer.endArray();
        return stringWriter.toString();
    }
}
