package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.domain.{Dependency, Release}

trait DependencyRepository {

  def findById(id: String): Dependency

  def update(release: Release, dependency: Dependency): Dependency

  def update(release: Release, dependency: Seq[Dependency]): Unit

  def create(release: Release, dependency: Dependency): Dependency

  def delete(dependency: Dependency): Unit

  def archive(release: Release, archivedDependencies: Seq[Dependency]): Unit

  def findAllIncomingDependencies(targetIds: Seq[String], statuses: Seq[String],
                                  referencingChildren: Boolean, includeTemplates: Boolean = true): Seq[Dependency]

}
