package com.xebialabs.xlrelease.script.builder

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.domain.ResolvableScriptTask
import com.xebialabs.xlrelease.script.{ScriptTimeoutContext, XlrScript, XlrScriptContext}

import java.time.Duration
import java.util.concurrent.ScheduledExecutorService
import scala.jdk.DurationConverters._

class ScriptTaskScriptContextBuilder(xlrConfig: XlrConfig, scriptTask: ResolvableScriptTask, timeoutExecutor: ScheduledExecutorService)
  extends ScriptContextBuilder {
  withScriptApi().withLogger().withExecutionId(scriptTask.getExecutionId)

  val timeoutEnabled = scriptTask.getScriptTimeout != -1 || xlrConfig.timeouts.scriptTaskTimeoutEnabled
  val timeout = if (scriptTask.getScriptTimeout == -1) {
    xlrConfig.timeouts.scriptTaskTimeout.toJava
  } else {
    Duration.ofSeconds(scriptTask.getScriptTimeout)
  }
  withTimeoutContext(new ScriptTimeoutContext(timeoutEnabled, timeoutExecutor, timeout))

  scriptTask.getEngine match {
    case "groovy" => withOpenApi().withGroovyDsl()
    case "jython" => withPythonSugar().withPythonGlobals().withPythonReleaseApi().withPythonUtilities()
  }

  override protected def doBuild(context: XlrScriptContext): Unit = {
    context.addDomainObjects(safe(scriptTask))

    val xlrScriptName = s"${scriptTask.getType.toString}[${scriptTask.getId}]"
    val xlrScript = XlrScript.byContent(xlrScriptName, scriptTask.getScript, wrap = true, checkPermissions = true)
    context.addScript(xlrScript)
  }

}