package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry.getDescriptor
import com.xebialabs.deployit.plugin.api.reflect.{Descriptor, Type}
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.configuration.AuditReportSettings
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired

class XLRelease900ReportAuditReportUpgrade @Autowired()(configurationRepository: ConfigurationRepository) extends BaseInitializingUpgrade with Logging {
  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "9.0.0#4")

  override def doUpgrade(): Boolean = {
    val descriptor: Descriptor = getDescriptor(Type.valueOf(classOf[AuditReportSettings]))
    val ci = descriptor.newInstance[AuditReportSettings](AuditReportSettings.AUDIT_REPORT_SETTINGS_ID)
    logger.debug(s"Creating CI: ${AuditReportSettings.AUDIT_REPORT_SETTINGS_ID}")
    configurationRepository.create(ci)
    true
  }
}
