/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.mbeans;

import com.xebialabs.xlrelease.service.CacheManagementService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;

@Component
@ManagedResource(objectName="com.xebialabs.xlrelease.settings:name=CacheControl", description="Cache control")
public class CacheControl {
    private final CacheManagementService cacheManagementService;

    @Autowired
    public CacheControl(CacheManagementService cacheManagementService) {
        this.cacheManagementService = cacheManagementService;
    }

    @ManagedOperation(description="List cache groups")
    public List<String> listCacheGroups() {
        return new ArrayList<String>(this.cacheManagementService.listCacheGroups());
    }

    @ManagedOperation(description="Clear all caches for a given group and broadcast event between cluster nodes")
    public void clearCache(String cacheGroup) {
        this.cacheManagementService.clearCacheGroup(cacheGroup, true);
    }

    @ManagedOperation(description="Fetch named cache statistics")
    public Map<String, Map<String, String>> cacheStats(String cacheGroup) {
        return new HashMap<String, Map<String, String>>(this.cacheManagementService.cacheStats(cacheGroup));
    }
}

