/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.events.handlers;

import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.events.JobCreatedEvent;
import com.xebialabs.xlrelease.scheduler.events.JobExecutionAbortRequestEvent;
import com.xebialabs.xlrelease.scheduler.events.JobReservedEvent;
import com.xebialabs.xlrelease.script.ScriptLifeCycle;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.reflect.ScalaSignature;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u00194Aa\u0002\u0005\u0001+!AA\u0005\u0001B\u0001B\u0003%Q\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u00151\u0004\u0001\"\u00018\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015y\u0005\u0001\"\u0001Q\u0005=QuNY#wK:$\b*\u00198eY\u0016\u0014(BA\u0005\u000b\u0003!A\u0017M\u001c3mKJ\u001c(BA\u0006\r\u0003\u0019)g/\u001a8ug*\u0011QBD\u0001\ng\u000eDW\rZ;mKJT!a\u0004\t\u0002\u0013ad'/\u001a7fCN,'BA\t\u0013\u0003%AXMY5bY\u0006\u00147OC\u0001\u0014\u0003\r\u0019w.\\\u0002\u0001'\r\u0001a\u0003\b\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005u\u0011S\"\u0001\u0010\u000b\u0005}\u0001\u0013!B:mMRR'\"A\u0011\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\t\u0010\u0003\u000f1{wmZ5oO\u0006A!n\u001c2Rk\u0016,X\r\u0005\u0002'O5\tA\"\u0003\u0002)\u0019\tA!j\u001c2Rk\u0016,X-A\btGJL\u0007\u000f\u001e'jM\u0016\u001c\u0015p\u00197f!\tYc&D\u0001-\u0015\tic\"\u0001\u0004tGJL\u0007\u000f^\u0005\u0003_1\u0012qbU2sSB$H*\u001b4f\u0007f\u001cG.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007I\"T\u0007\u0005\u00024\u00015\t\u0001\u0002C\u0003%\u0007\u0001\u0007Q\u0005C\u0003*\u0007\u0001\u0007!&A\u0007p]*{'MU3tKJ4X\r\u001a\u000b\u0003qm\u0002\"aF\u001d\n\u0005iB\"\u0001B+oSRDQ\u0001\u0010\u0003A\u0002u\n1B[8c%\u0016\u001cXM\u001d<fIB\u0011ahP\u0007\u0002\u0015%\u0011\u0001I\u0003\u0002\u0011\u0015>\u0014'+Z:feZ,G-\u0012<f]RD#\u0001\u0002\"\u0011\u0005\r+U\"\u0001#\u000b\u0005-q\u0011B\u0001$E\u0005%\u0019VOY:de&\u0014W-\u0001\u0007p]*{'m\u0011:fCR,G\r\u0006\u00029\u0013\")!*\u0002a\u0001\u0017\u0006y!n\u001c2De\u0016\fG/\u001a3Fm\u0016tG\u000f\u0005\u0002?\u0019&\u0011QJ\u0003\u0002\u0010\u0015>\u00147I]3bi\u0016$WI^3oi\"\u0012QAQ\u0001\u001d_:TuNY#yK\u000e,H/[8o\u0003\n|'\u000f\u001e*fcV,7\u000f^3e)\tA\u0014\u000bC\u0003S\r\u0001\u00071+A\u0003fm\u0016tG\u000f\u0005\u0002?)&\u0011QK\u0003\u0002\u001e\u0015>\u0014W\t_3dkRLwN\\!c_J$(+Z9vKN$XI^3oi\"\u0012aA\u0011\u0015\u0003\u0001a\u0003\"!\u00171\u000e\u0003iS!a\u0017/\u0002\u0015M$XM]3pif\u0004XM\u0003\u0002^=\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001`\u0003\ry'oZ\u0005\u0003Cj\u0013qaU3sm&\u001cW\r\u000b\u0002\u0001GB\u00111\tZ\u0005\u0003K\u0012\u0013Q\"\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014\b")
public class JobEventHandler
implements Logging {
    private final JobQueue jobQueue;
    private final ScriptLifeCycle scriptLifeCycle;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        JobEventHandler jobEventHandler = this;
        synchronized (jobEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Subscribe
    public void onJobReserved(JobReservedEvent jobReserved) {
        this.logger().debug((Function0 & Serializable)() -> "removing job " + jobReserved + " as it is reserved on another node");
        this.jobQueue.cancelIf(x$1 -> x$1.id() == jobReserved.jobId());
    }

    @Subscribe
    public void onJobCreated(JobCreatedEvent jobCreatedEvent) {
        Job job = jobCreatedEvent.job();
        if (job != null) {
            this.logger().debug((Function0 & Serializable)() -> "submitting broadcasted job " + job.id());
            this.jobQueue.submitBroadcasted(job);
            return;
        }
    }

    @Subscribe
    public void onJobExecutionAbortRequested(JobExecutionAbortRequestEvent event) {
        this.logger().debug((Function0 & Serializable)() -> "removing job " + event.jobId() + " with execution id " + event.executionId() + " as it is requested to be aborted");
        this.scriptLifeCycle.tryAborting(event.executionId());
        this.jobQueue.cancelIf(x$2 -> x$2.id() == event.jobId());
    }

    public JobEventHandler(JobQueue jobQueue, ScriptLifeCycle scriptLifeCycle) {
        this.jobQueue = jobQueue;
        this.scriptLifeCycle = scriptLifeCycle;
        Logging.$init$((Logging)this);
    }
}

