/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.workers;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.CreatedFromCreateReleaseTask;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.events.ReleaseStartedFromCreateReleaseTaskEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.IdType;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseInformation;
import com.xebialabs.xlrelease.scheduler.workers.Worker;
import com.xebialabs.xlrelease.script.EncryptionHelper$;
import com.xebialabs.xlrelease.script.TaskSoftReference;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.UsernamePassword;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.security.authentication.AuthenticationService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Uga\u0002\f\u0018!\u0003\r\tA\t\u0005\u0006c\u0001!\tA\r\u0005\u0006m\u00011\ta\u000e\u0005\u0006}\u00011\ta\u0010\u0005\u0006\r\u00021\ta\u0012\u0005\u0006\u001d\u00021\ta\u0014\u0005\u0006'\u00021\t\u0001\u0016\u0005\u0006;\u00021\tA\u0018\u0005\u0006G\u00021\t\u0001\u001a\u0005\u0006Q\u0002!\t!\u001b\u0005\b\u00033\u0001A\u0011BA\u000e\u0011\u001d\t\t\u0003\u0001C\u0005\u0003GAq!a\u0011\u0001\t\u0013\t)\u0005C\u0004\u0002T\u0001!I!!\u0016\t\u000f\u0005e\u0003\u0001\"\u0003\u0002\\!9\u0011q\f\u0001\u0005\n\u0005\u0005\u0004bBA0\u0001\u0011%\u00111\u000e\u0005\b\u00033\u0003A\u0011BAN\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KCq!!-\u0001\t\u0013\t\u0019\fC\u0004\u0002:\u0002!I!a/\t\u000f\u0005\r\u0007\u0001\"\u0003\u0002F\n12I]3bi\u0016\u0014V\r\\3bg\u0016$\u0016m]6M_\u001eL7M\u0003\u0002\u00193\u00059qo\u001c:lKJ\u001c(B\u0001\u000e\u001c\u0003%\u00198\r[3ek2,'O\u0003\u0002\u001d;\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003=}\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0001\n1aY8n\u0007\u0001\u00192\u0001A\u0012*!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fMB\u0011!fL\u0007\u0002W)\u0011A&L\u0001\u0006g24GG\u001b\u0006\u0002]\u0005AqM]5{u2,G-\u0003\u00021W\t9Aj\\4hS:<\u0017A\u0002\u0013j]&$H\u0005F\u00014!\t!C'\u0003\u00026K\t!QK\\5u\u0003!)g/\u001a8u\u0005V\u001cX#\u0001\u001d\u0011\u0005ebT\"\u0001\u001e\u000b\u0005mZ\u0012AB3wK:$8/\u0003\u0002>u\t\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\u0002'I,G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0016\u0003\u0001\u0003\"!\u0011#\u000e\u0003\tS!aQ\u000e\u0002\r\u0005\u001cGo\u001c:t\u0013\t)%IA\nSK2,\u0017m]3BGR|'oU3sm&\u001cW-\u0001\bsK2,\u0017m]3TKJ4\u0018nY3\u0016\u0003!\u0003\"!\u0013'\u000e\u0003)S!aS\u000e\u0002\u000fM,'O^5dK&\u0011QJ\u0013\u0002\u000f%\u0016dW-Y:f'\u0016\u0014h/[2f\u0003-\u0019\u0017.\u00133TKJ4\u0018nY3\u0016\u0003A\u0003\"!S)\n\u0005IS%aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016\fQ#Y;uQ\u0016tG/[2bi&|gnU3sm&\u001cW-F\u0001V!\t16,D\u0001X\u0015\tA\u0016,\u0001\bbkRDWM\u001c;jG\u0006$\u0018n\u001c8\u000b\u0005i[\u0012\u0001C:fGV\u0014\u0018\u000e^=\n\u0005q;&!F!vi\",g\u000e^5dCRLwN\\*feZL7-Z\u0001\u0012a\u0016\u0014X.[:tS>t7\t[3dW\u0016\u0014X#A0\u0011\u0005\u0001\fW\"A-\n\u0005\tL&!\u0005)fe6L7o]5p]\u000eCWmY6fe\u0006q1m\\7nK:$8+\u001a:wS\u000e,W#A3\u0011\u0005%3\u0017BA4K\u00059\u0019u.\\7f]R\u001cVM\u001d<jG\u0016\f\u0011b\u001d;beR$\u0016m]6\u0015\u0005)t\bCA6|\u001d\ta\u0017P\u0004\u0002nq:\u0011an\u001e\b\u0003_Zt!\u0001];\u000f\u0005E$X\"\u0001:\u000b\u0005M\f\u0013A\u0002\u001fs_>$h(C\u0001!\u0013\tqr$\u0003\u0002\u001d;%\u0011!dG\u0005\u00031eI!A_\f\u0002\r]{'o[3s\u0013\taXP\u0001\u0011De\u0016\fG/\u001a*fY\u0016\f7/\u001a+bg.,\u00050Z2vi&|gNU3tk2$(B\u0001>\u0018\u0011\u0019y\u0018\u00021\u0001\u0002\u0002\u00059A/Y:l%\u00164\u0007CBA\u0002\u0003\u0013\ti!\u0004\u0002\u0002\u0006)\u0019\u0011qA\u000e\u0002\rM\u001c'/\u001b9u\u0013\u0011\tY!!\u0002\u0003#Q\u000b7o[*pMR\u0014VMZ3sK:\u001cW\r\u0005\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019bG\u0001\u0007I>l\u0017-\u001b8\n\t\u0005]\u0011\u0011\u0003\u0002\u0012\u0007J,\u0017\r^3SK2,\u0017m]3UCN\\\u0017!G2p]:,7\r^,ji\"\u001c%/Z1uK\u0012\u0014V\r\\3bg\u0016$2A[A\u000f\u0011\u001d\tyB\u0003a\u0001\u0003\u001b\tA\u0001^1tW\u0006\u00012M]3bi\u0016\u001cVO\u0019*fY\u0016\f7/\u001a\u000b\u0005\u0003K\t\tEE\u0004\u0002()\fY#!\r\u0007\r\u0005%\u0002\u0001AA\u0013\u00051a$/\u001a4j]\u0016lWM\u001c;?!\r!\u0013QF\u0005\u0004\u0003_)#a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003g\ti$\u0004\u0002\u00026)!\u0011qGA\u001d\u0003\tIwN\u0003\u0002\u0002<\u0005!!.\u0019<b\u0013\u0011\ty$!\u000e\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000f\u0005}1\u00021\u0001\u0002\u000e\u0005y1\u000f^1siN+(MU3mK\u0006\u001cX\r\u0006\u0004\u0002&\u0005\u001d\u0013\u0011\n\u0005\b\u0003?a\u0001\u0019AA\u0007\u0011\u001d\tY\u0005\u0004a\u0001\u0003\u001b\n!b];c%\u0016dW-Y:f!\u0011\ty!a\u0014\n\t\u0005E\u0013\u0011\u0003\u0002\b%\u0016dW-Y:f\u0003y1\u0018\r\\5eCR,7I]3bi\u0016\u0014V\r\\3bg\u0016\u0014VmY;sg&|g\u000eF\u00024\u0003/Bq!a\b\u000e\u0001\u0004\ti!\u0001\u000ewC2LG-\u0019;f%\u0016\fX/\u001b:fIB\u0013x\u000e]3si&,7\u000fF\u00024\u0003;Bq!a\b\u000f\u0001\u0004\ti!\u0001\tdQ\u0016\u001c7\u000eU3s[&\u001c8/[8ogR!\u00111MA5!\r\u0001\u0017QM\u0005\u0004\u0003OJ&\u0001E+tKJt\u0017-\\3QCN\u001cxo\u001c:e\u0011\u001d\tyb\u0004a\u0001\u0003\u001b!\u0002\"a\u0019\u0002n\u0005=\u00141\u0011\u0005\b\u0003?\u0001\u0002\u0019AA\u0007\u0011\u001d\t\t\b\u0005a\u0001\u0003g\n\u0011B]3mK\u0006\u001cX-\u00133\u0011\t\u0005U\u0014Q\u0010\b\u0005\u0003o\nI\b\u0005\u0002rK%\u0019\u00111P\u0013\u0002\rA\u0013X\rZ3g\u0013\u0011\ty(!!\u0003\rM#(/\u001b8h\u0015\r\tY(\n\u0005\b\u0003\u000b\u0003\u0002\u0019AAD\u0003I\u0011X-];je\u0016$\u0007+\u001a:nSN\u001c\u0018n\u001c8\u0011\t\u0005%\u0015QS\u0007\u0003\u0003\u0017SA!!$\u0002\u0010\u0006Q\u0001/\u001a:nSN\u001c\u0018n\u001c8\u000b\u0007i\u000b\tJC\u0002\u0002\u0014v\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0005\u0003/\u000bYI\u0001\u0006QKJl\u0017n]:j_:\fQb\u0019:fCR,'+\u001a7fCN,GCBA'\u0003;\u000by\nC\u0004\u0002 E\u0001\r!!\u0004\t\u000f\u0005\u0005\u0016\u00031\u0001\u0002d\u0005\u00112o\u0019:jaR,6/\u001a:oC6,\u0007+Y:t\u00031\u0019H/\u0019:u%\u0016dW-Y:f)\u0019\t9+!,\u00020B\u0019A%!+\n\u0007\u0005-VEA\u0004C_>dW-\u00198\t\u000f\u0005}!\u00031\u0001\u0002\u000e!9\u00111\n\nA\u0002\u00055\u0013\u0001\b;ie><\u0018JZ'bq\u000e{gnY;se\u0016t7-\u001f*fC\u000eDW\r\u001a\u000b\u0004g\u0005U\u0006bBA\\'\u0001\u0007\u0011QJ\u0001\fe>|GOU3mK\u0006\u001cX-A\u000ehKR\u001cVO\u0019*fY\u0016\f7/\u001a)be\u0006l7O\u0012:p[R\u000b7o\u001b\u000b\u0007\u0003\u001b\ni,a0\t\u000f\u0005}A\u00031\u0001\u0002\u000e!9\u0011\u0011\u0019\u000bA\u0002\u00055\u0013AE:vEJ+G.Z1tKR+W\u000e\u001d7bi\u0016\fabZ3u%\u0016dW-Y:f\u0019&t7\u000e\u0006\u0003\u0002H\u0006E\u0007\u0003BAe\u0003\u001fl!!a3\u000b\t\u00055\u0017\u0011H\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u0000\u0005-\u0007bBAj+\u0001\u0007\u0011QJ\u0001\be\u0016dW-Y:f\u0001")
public interface CreateReleaseTaskLogic
extends Logging {
    public XLReleaseEventBus eventBus();

    public ReleaseActorService releaseActorService();

    public ReleaseService releaseService();

    public CiIdService ciIdService();

    public AuthenticationService authenticationService();

    public PermissionChecker permissionChecker();

    public CommentService commentService();

    public static /* synthetic */ Worker.CreateReleaseTaskExecutionResult startTask$(CreateReleaseTaskLogic $this, TaskSoftReference taskRef) {
        return $this.startTask(taskRef);
    }

    default public Worker.CreateReleaseTaskExecutionResult startTask(TaskSoftReference<CreateReleaseTask> taskRef) {
        Worker.CreateReleaseTaskExecutionResult createReleaseTaskExecutionResult;
        block3: {
            try {
                CreateReleaseTask task = taskRef.get();
                this.validateRequiredProperties(task);
                this.validateCreateReleaseRecursion(task);
                if (StringUtils.hasText((String)task.getCreatedReleaseId()) && Ids.isReleaseId((String)task.getCreatedReleaseId())) {
                    createReleaseTaskExecutionResult = this.connectWithCreatedRelease(task);
                    break block3;
                }
                createReleaseTaskExecutionResult = this.createSubRelease(task);
            }
            catch (Exception ex) {
                String message = String.format("Exception occurred while creating a release. Reason: %s.", ex.getMessage());
                this.logger().error((Function0 & Serializable)() -> message, (Function0 & Serializable)() -> ex);
                createReleaseTaskExecutionResult = new Worker.CreateReleaseTaskExecutionResulCreateReleaseFailure(taskRef.getTaskId(), taskRef.getExecutionId(), ex.getMessage());
            }
        }
        return createReleaseTaskExecutionResult;
    }

    private Worker.CreateReleaseTaskExecutionResult connectWithCreatedRelease(CreateReleaseTask task) {
        Worker.CreateReleaseTaskExecutionResult createReleaseTaskExecutionResult;
        block4: {
            String createdReleaseId = task.getCreatedReleaseId();
            try {
                Option maybeReleaseInfo;
                Option option = maybeReleaseInfo = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.releaseService().getReleaseInformation(createdReleaseId)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    ReleaseInformation releaseInfo = (ReleaseInformation)some.value();
                    createReleaseTaskExecutionResult = new Worker.CreateReleaseTaskConnectReleaseSuccess(task.getId(), task.getExecutionId(), createdReleaseId, releaseInfo.status());
                    break block4;
                }
                if (None$.MODULE$.equals(option)) {
                    String message = String.format("Release '%s' could not be found", createdReleaseId);
                    createReleaseTaskExecutionResult = new Worker.CreateReleaseTaskConnectReleaseFailure(task.getId(), task.getExecutionId(), message);
                    break block4;
                }
                throw new MatchError((Object)option);
            }
            catch (Exception ex) {
                this.logger().error((Function0 & Serializable)() -> "Exception occurred while connecting with a release '" + createdReleaseId + "'", (Function0 & Serializable)() -> ex);
                String message = String.format("Exception occurred while connecting with a release '%s'. Reason: '%s'", createdReleaseId, ex.getMessage());
                createReleaseTaskExecutionResult = new Worker.CreateReleaseTaskConnectReleaseFailure(task.getId(), task.getExecutionId(), message);
            }
        }
        return createReleaseTaskExecutionResult;
    }

    private Worker.CreateReleaseTaskExecutionResult createSubRelease(CreateReleaseTask task) {
        UsernamePassword scriptUserPass = this.checkPermissions(task);
        Release subRelease = this.createRelease(task, scriptUserPass);
        boolean startSubReleaseOnCreation = task.getStartRelease();
        if (startSubReleaseOnCreation) {
            return this.startSubRelease(task, subRelease);
        }
        return new Worker.CreateReleaseTaskExecutionResultSuccess(task.getId(), task.getExecutionId(), subRelease.getId());
    }

    private Worker.CreateReleaseTaskExecutionResult startSubRelease(CreateReleaseTask task, Release subRelease) {
        Worker.CreateReleaseTaskExecutionResult createReleaseTaskExecutionResult;
        block3: {
            try {
                this.checkPermissions(task, subRelease.getId(), XLReleasePermissions.START_RELEASE);
                boolean isStarted = this.startRelease(task, subRelease);
                if (isStarted) {
                    createReleaseTaskExecutionResult = new Worker.CreateReleaseTaskExecutionResultSuccess(task.getId(), task.getExecutionId(), subRelease.getId());
                    break block3;
                }
                String message = String.format("Release '%s' could not be started", subRelease.getTitle());
                createReleaseTaskExecutionResult = new Worker.CreateReleaseTaskExecutionResultStartReleaseFailure(task.getId(), task.getExecutionId(), subRelease.getId(), message);
            }
            catch (Exception ex) {
                String message = String.format("Release '%s' could not be started. Reason: '%s'", subRelease.getTitle(), ex.getMessage());
                createReleaseTaskExecutionResult = new Worker.CreateReleaseTaskExecutionResultStartReleaseFailure(task.getId(), task.getExecutionId(), subRelease.getId(), message);
            }
        }
        return createReleaseTaskExecutionResult;
    }

    private void validateCreateReleaseRecursion(CreateReleaseTask task) {
        if (Strings.isNotBlank((String)task.getTemplateIdVariable()) && Strings.isNotBlank((String)task.getRelease().getOriginTemplateId())) {
            String string = task.getRelease().getOriginTemplateId();
            String string2 = task.getTemplateId();
            Preconditions.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (Object)"The template that will be used to create a new release must be different from the template used to create the current release.");
            return;
        }
    }

    private void validateRequiredProperties(CreateReleaseTask task) {
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)task.getNewReleaseTitle()), (Object)"Title of the release to be created cannot be empty.");
        String errorMessageTemplate = Strings.isNotBlank((String)task.getTemplateIdVariable()) ? "Template that will be used to create a release couldn't be derived from variable " + task.getTemplateIdVariable() : "Template that will be used to create a release must be specified.";
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)task.getTemplateId()), (Object)errorMessageTemplate);
        Preconditions.checkArgument((boolean)this.releaseService().exists(task.getTemplateId()), (Object)("Template provided in variable " + task.getTemplateIdVariable() + " must be a valid template id."));
    }

    private UsernamePassword checkPermissions(CreateReleaseTask task) {
        return this.checkPermissions(task, task.getTemplateId(), null);
    }

    private UsernamePassword checkPermissions(CreateReleaseTask task, String releaseId, Permission requiredPermission) {
        UsernamePassword usernamePass = null;
        try {
            usernamePass = this.authenticationService().loginScriptUser((Task)task);
            String templateId = this.releaseService().getFullId(Ids.getFolderlessId((String)task.getTemplateId()));
            String targetFolderId = !Ids.isNullId((String)task.getFolderId()) ? task.getFolderId() : Ids.findFolderId((String)templateId);
            this.permissionChecker().checkIsAllowedToCreateReleaseFromTemplate(templateId, targetFolderId);
            if (requiredPermission != null) {
                this.permissionChecker().check(requiredPermission, releaseId);
            }
        }
        finally {
            this.authenticationService().logoutScriptUser();
        }
        return usernamePass;
    }

    private Release createRelease(CreateReleaseTask task, UsernamePassword scriptUsernamePass) {
        Release subReleaseTemplate = this.releaseService().findById(task.getTemplateId());
        Release releaseMetadata = this.getSubReleaseParamsFromTask(task, subReleaseTemplate);
        String rootReleaseId = Optional.ofNullable(task.getRelease().getRootReleaseId()).orElse(task.getRelease().getId());
        try {
            this.throwIfMaxConcurrencyReached(this.releaseService().findByIdIncludingArchived(rootReleaseId));
        }
        catch (NotFoundException ex) {
            this.logger().debug((Function0 & Serializable)() -> String.format("Root release not found. Missing release max concurrency check. Reason: %s.", ex.getMessage()), (Function0 & Serializable)() -> ex);
        }
        releaseMetadata.setRootReleaseId(rootReleaseId);
        releaseMetadata.setOwner(scriptUsernamePass.username());
        releaseMetadata.setScriptUsername(scriptUsernamePass.username());
        releaseMetadata.setScriptUserPassword(scriptUsernamePass.password());
        EncryptionHelper$.MODULE$.decrypt((ConfigurationItem)releaseMetadata);
        Release subRelease = this.releaseService().createFromTemplate(task.getTemplateId(), releaseMetadata, task.getFolderId());
        this.commentService().create((Task)task, String.format("Created release %s.", this.getReleaseLink(subRelease)), User.AUTHENTICATED_USER, true);
        this.eventBus().publish((XLReleaseEvent)new ReleaseCreatedEvent(subRelease, (ReleaseCreationSource)new CreatedFromCreateReleaseTask(task, subReleaseTemplate.getId())));
        return subRelease;
    }

    private boolean startRelease(CreateReleaseTask task, Release subRelease) {
        boolean hasBeenStarted;
        block0: {
            Release startedRelease = this.releaseActorService().startRelease(subRelease.getId(), User.SYSTEM);
            hasBeenStarted = startedRelease.getStatus().hasBeenStarted();
            if (!hasBeenStarted) break block0;
            this.commentService().create(task.getId(), String.format("Started release %s.", this.getReleaseLink(startedRelease)), User.AUTHENTICATED_USER, true);
            this.eventBus().publish((XLReleaseEvent)new ReleaseStartedFromCreateReleaseTaskEvent(task, subRelease));
        }
        return hasBeenStarted;
    }

    private void throwIfMaxConcurrencyReached(Release rootRelease) {
        int maxConcurrency = rootRelease.getMaxConcurrentReleases();
        List<Release> spawnedReleases = this.releaseService().findSpawnedReleases(rootRelease.getId(), maxConcurrency);
        int rootCount = rootRelease.isDefunct() ? 0 : 1;
        int currentlyRunning = spawnedReleases.size() + rootCount;
        this.logger().debug((Function0 & Serializable)() -> new Tuple4((Object)"maxConcurrency: {}, currently running releases ({}): {}", (Object)BoxesRunTime.boxToInteger((int)maxConcurrency), (Object)BoxesRunTime.boxToInteger((int)currentlyRunning), (Object)spawnedReleases));
        if (currentlyRunning >= maxConcurrency) {
            throw new IllegalStateException(String.format("Exceeded maximum number of concurrent releases created from %s. Current maximum is %s. This value can be configured in deployit-defaults.properties: xlrelease.Release.maxConcurrentReleases", rootRelease.getTitle(), BoxesRunTime.boxToInteger((int)maxConcurrency)));
        }
    }

    private Release getSubReleaseParamsFromTask(CreateReleaseTask task, Release subReleaseTemplate) {
        Map templateVariables = VariableHelper$.MODULE$.indexByKey(subReleaseTemplate.getVariables());
        List variablesShownOnReleaseStart = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(task.getTemplateVariables()).asScala().filter((Function1 & Serializable)variable -> BoxesRunTime.boxToBoolean((boolean)CreateReleaseTaskLogic.$anonfun$getSubReleaseParamsFromTask$1(templateVariables, variable)))).asJava();
        List variables = VariableHelper$.MODULE$.fillVariableValues(subReleaseTemplate.getVariables(), variablesShownOnReleaseStart);
        ArrayList subReleaseTags = new ArrayList(subReleaseTemplate.getTags());
        subReleaseTags.addAll(task.getReleaseTags());
        Release release = ReleaseBuilder.newRelease().withVariables(variables).withOriginTemplateId(task.getTemplateId()).withTitle(task.getNewReleaseTitle()).withOwner(task.getRelease().getScriptUsername()).withScriptUsername(task.getRelease().getScriptUsername()).withScriptUserPassword(task.getRelease().getScriptUserPassword()).withDisableNotifications(task.getRelease().isDisableNotifications()).withTags(subReleaseTags).build();
        release.setProperty("riskProfile", task.getProperty("riskProfile"));
        this.releaseService().setDatesFromTemplate(release, subReleaseTemplate);
        release.setStartedFromTaskId(task.getId());
        release.setAbortOnFailure(subReleaseTemplate.isAbortOnFailure());
        release.setAllowPasswordsInAllFields(subReleaseTemplate.isAllowPasswordsInAllFields());
        release.setArchiveRelease(subReleaseTemplate.isArchiveRelease());
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(release.getId(), release.getVariables(), this.ciIdService());
        return release;
    }

    private String getReleaseLink(Release release) {
        return String.format("[%s](#/releases/%s)", release.getTitle(), IdType.DOMAIN.convertToViewId(release.getId()));
    }

    public static /* synthetic */ boolean $anonfun$getSubReleaseParamsFromTask$1(Map templateVariables$1, Variable variable) {
        return templateVariables$1.containsKey(variable.getKey()) && ((Variable)templateVariables$1.get(variable.getKey())).getShowOnReleaseStart();
    }

    public static void $init$(CreateReleaseTaskLogic $this) {
    }
}

