/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.spring.configuration;

import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.ldap.LdapHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;

@AutoConfiguration
@ConditionalOnBean(value={BaseLdapPathContextSource.class})
@ConditionalOnEnabledHealthIndicator(value="ldap")
public class XlrLdapHealthAutoConfiguration {
    SpringSecurityLdapTemplate template;

    public XlrLdapHealthAutoConfiguration(BaseLdapPathContextSource ldapServer) {
        this.template = new SpringSecurityLdapTemplate((ContextSource)ldapServer);
    }

    @Bean
    public HealthContributor ldapHealthContributor() {
        return new LdapHealthIndicator((LdapOperations)this.template);
    }
}

