package com.xebialabs.deployit.plumbing;

import java.io.IOException;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.MediaType;

public class SseDisableBufferingFilter extends HttpFilter {

    @Override
    protected void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain)
            throws IOException, ServletException {
        String acceptHeader = req.getHeader("Accept");
        if (acceptHeader != null && acceptHeader.contains(MediaType.SERVER_SENT_EVENTS)) {
                res.setHeader("X-Accel-Buffering", "no");
        }
        chain.doFilter(req, res);
    }
}
