package com.xebialabs.xlrelease.actors

import com.typesafe.config.Config
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.support.pekko.spring.ScalaSpringAwareBean
import org.apache.pekko.actor.ActorLogging
import org.apache.pekko.persistence.{PersistentActor, RuntimePluginConfig}

trait XlrPersistentActor extends PersistentActor with ActorLogging with ScalaSpringAwareBean with RuntimePluginConfig {

  override def journalPluginConfig: Config = {
    XlrConfig.getInstance.pekko.pekkoPersistenceConfig.getConfig("jdbc-journal")
  }

  override def snapshotPluginConfig: Config = {
    XlrConfig.getInstance.pekko.pekkoPersistenceConfig.getConfig("jdbc-snapshot-store")
  }

}
