package com.xebialabs.xlrelease.api.internal;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.sse.SseEventSink;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.xlrelease.service.SseService;

@Path("/sse")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@Controller
public class SseResource {

    private SseService sseService;

    @Autowired
    public SseResource(SseService sseService) {
        this.sseService = sseService;
    }

    @GET
    @Produces(MediaType.SERVER_SENT_EVENTS)
    public void subscribeToNotifications(@Context SseEventSink sink) {
        this.sseService.subscribeUserToSink(sink);
    }
}
